<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

require '../../modelo/carrito.php';
require '../../modelo/environment.php';
require '../envio/costo_envio.php';
require '../envio/costo_paqueteria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/paqueteria.php';

$response = array();

if (
    !isset($_POST['cp']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

$cp = $_POST['cp'];

$carrito = Carrito::mdlGetCarritoByIdUsuario($id_usuario);

if (!$carrito) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron productos';
    echo json_encode($response);
    return;
}

$costo_envio = Envio::getPaqueteriasCheckout($cp, $carrito);

usort($costo_envio, function ($a, $b) {
    return $a['total_pricing'] - $b['total_pricing'];
});

$envio = array();

$i = 0;

foreach ($costo_envio as $key => $value) {
    if($value['provider'] != 'ESTAFETA'){
        $id_envio = Paqueteria::mdlGetPaqueteriaByNombre($value['provider']);
        if(!$id_envio){
            //continuamos con el siguiente
            continue;
        }
        $envio[$i]['paqueteria'] = $value['provider'];
        $envio[$i]['precio'] = $value['total_pricing'];
        $envio[$i]['id_paqueteria'] = $id_envio['id_paqueteria'];
        $i++;
    }
}

$response['response'] = 'success';
$response['data'] = $envio;
echo json_encode($response);