<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/carrito.php';
require '../../modelo/environment.php';
// require '../calificacion/decodeCalificacion.php';

$url_servidor = Environment::getUrlServidor();
const LIMITE_DE_CARROS_POR_PAGINA = 20;

$numero_pagina = ($_POST['numero_pagina'] - 1);
$offset = $numero_pagina * LIMITE_DE_CARROS_POR_PAGINA;

$termino_busqueda = $_POST['termino_busqueda'];
$orderBy = json_decode($_POST['orderBy'], true);
$filters = json_decode($_POST['filters'], true);

$carritos = Carrito::mdlSearchLimit($filters, $termino_busqueda, $orderBy, $offset, LIMITE_DE_CARROS_POR_PAGINA);
$total_carritos = Carrito::mdlSearchTotal($filters, $termino_busqueda);

if (!$carritos) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron carritos';
    echo json_encode($response);
    return;
}

foreach ($carritos as $key => $carrito) {
    $respuesta = $carrito['respuesta'];

    $carritos[$key]['nombre_completo'] = $carrito['nombre'] . ' ' . $carrito['apellido_paterno'] . ' ' . $carrito['apellido_materno'];

    // Agregamos la primera imagen del producto y su color de categoria para identificarlo
    if(!is_null($carrito['imagenes_producto'])){
        $imagenes = json_decode($carrito['imagenes_producto']);
        $imagenes_url = array();
    
        $carritos[$key]['url_imagen'] = $url_servidor . $imagenes[0]->url;
    }


    // Le agregamos la ruta a las imagenes del carrito
    if($carrito['imagen_resena'] != null) {
        $imagenes_resena = json_decode($carrito['imagen_resena']);
        $imagenes_url = array();
        
        foreach ($imagenes_resena as $key_imagen => $value) {
            $imagenes_url[$key_imagen]['id_imagen'] = $value->id_imagen;
            $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $value->url_imagen;
        }
    }

    $carritos[$key]['imagen_resena'] = $imagenes_url;
    $carritos[$key]['color_fondo'] = $carrito['color_categoria'];

    // Formateamos la fecha de la orden
    $fecha = date($carrito['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
    $carritos[$key]['fecha_alta'] = $fechaFormat;
    
}

$response['response'] = 'success';
$response['data'] = array(
    "carritos" => $carritos,
    "total_carritos" => $total_carritos['total'],
    "limite" => LIMITE_DE_CARROS_POR_PAGINA,
);

echo json_encode($response);