<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/carrito.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_carrito']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_carrito = $_POST['id_carrito'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('carrito', $id_carrito));

$carrito = Carrito::mdlDeleteCarrito($id_usuario, $id_carrito);

if (!$carrito) {
    $response['response'] = 'error';
    $response['data'] = 'No se eliminó el producto del carrito';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'carrito', $id_carrito, $id_usuario, $valor_anterior);

$response['response'] = 'success';

echo json_encode($response);