<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/carrito.php';
require '../../modelo/producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['productos'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$productos = $_POST['productos'];

$jsonString = trim($productos, '"');

$jsonString = stripslashes($jsonString);

$dataArray = json_decode($jsonString, true);

if (json_last_error() === JSON_ERROR_NONE) {

    foreach ($dataArray as $key => $value) {
        $id_producto = $value['id_producto'];
        $cantidad = $value['cantidad'];

        $carrito_existente = Carrito::mdlGetCarritoByIdCarrito($id_usuario, $id_producto);

        if ($carrito_existente != false) {
            $id_producto = $carrito_existente['id_producto'];
            $cantidad = $carrito_existente['cantidad'] + $cantidad;

            if (!Carrito::mdlUpdateCarrito($carrito_existente['id_carrito'], $id_usuario, $id_producto, $cantidad)) {
                $response['response'] = 'error';
                $response['data'] = 'No se actualizo el carrito';
                echo json_encode($response);
            }
            continue;
        }

        $carrito = Carrito::mdlAddCarrito($id_usuario, $id_producto, $cantidad);

        if (!$carrito) {
            $response['response'] = 'error';
            $response['data'] = 'No se agregó el producto al carrito';
            echo json_encode($response);
            continue;
        }
    }
} else {
    echo "Error al decodificar JSON: " . json_last_error_msg();
}

$response['response'] = 'success';

echo json_encode($response);