<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/carrito.php';
require '../../modelo/producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_producto']) ||
    !isset($_POST['cantidad'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_producto = $_POST['id_producto'];
$cantidad = $_POST['cantidad'];

// function validateStock($cantidad, $stock) {
//     if ($cantidad > $stock) {
//         $response['response'] = 'error';
//         $response['data'] = 'No hay suficiente stock para agregar este producto al carrito.';
//         echo json_encode($response);
//         return false;
//     }
//     return true;
// }

// $validar_stock = Producto::mdlVerificarProductoStock($id_producto);

// if (!validateStock($cantidad, $validar_stock['stock'])) {
//     return;
// }

$carrito_existente = Carrito::mdlGetCarritoByIdCarrito($id_usuario, $id_producto);

if ($carrito_existente != false) {
    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('carrito', $carrito_existente['id_carrito']));

    $id_producto = $carrito_existente['id_producto'];
    $cantidad = $carrito_existente['cantidad'] + $cantidad;

    // if (!validateStock($cantidad, $validar_stock['stock'])) {
    //     return;
    // }

    if (Carrito::mdlUpdateCarrito($carrito_existente['id_carrito'], $id_usuario, $id_producto, $cantidad)) {
        ModeloHistory::mdlAddNewRegister('update', 'carrito', $carrito_existente['id_carrito'], $id_usuario, $valor_anterior);
        $response['response'] = 'success';
        $response['data'] = $id_producto;
        echo json_encode($response);
        return;
    }
}

$carrito = Carrito::mdlAddCarrito($id_usuario, $id_producto, $cantidad);

if (!$carrito) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó el producto al carrito';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'carrito', $carrito, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $carrito;

echo json_encode($response);
