<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/card_publicitario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    isset($_POST['id_usuario']) &&
    isset($_POST['id_card_publicitario'])
) {
    $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
    $id_card_publicitario = $_POST['id_card_publicitario'];

    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('card_publicitario', $id_card_publicitario));

    $cardPublicitario = CardPublicitario::mdlDeleteCardPublicitario($id_card_publicitario);

    if (!$cardPublicitario) {
        $response['response'] = 'error';
        $response['data'] = 'No se eliminó el card publicitario';
    } else {
        ModeloHistory::mdlAddNewRegister('delete', 'card_publicitario', $id_card_publicitario, $id_usuario, $valor_anterior);
        $response['response'] = 'success';
        $response['data'] = 'Card publicitario eliminado correctamente';
    }

    echo json_encode($response);
    return;
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}