<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/card_publicitario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';

$response = array();

if (
    isset($_POST['id_usuario']) &&
    isset($_POST['titulo']) &&
    isset($_POST['descripcion']) &&
    isset($_POST['url_imagen']) &&
    isset($_POST['link']) &&
    isset($_POST['color'])
) {
    $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

    if (!$id_usuario) {
        $response['response'] = 'error';
        $response['data'] = 'Id del usuario incorrecto.';
        echo json_encode($response);
        return;
    }

    $titulo = $_POST['titulo'];
    $descripcion = $_POST['descripcion'];
    $url_imagen = $_POST['url_imagen'];
    $link = $_POST['link'];
    $color = $_POST['color'];

    $cardPublicitario = CardPublicitario::mdlAddCardPublicitario($titulo, $descripcion, $url_imagen, $link, $color);

    if (!$cardPublicitario) {
        $response['response'] = 'error';
        $response['data'] = 'No se agregó el card publicitario';
    } else {
        ModeloHistory::mdlAddNewRegister('create', 'card_publicitario', $cardPublicitario, $id_usuario, NULL);
        $response['response'] = 'success';
        $response['data'] = $cardPublicitario;
    }

    echo json_encode($response);
    return;
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

?>