
<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/calificacion_producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_calificacion_producto']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_calificacion_producto = $_POST['id_calificacion_producto'];
$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('calificacion_producto', $id_calificacion_producto));

$calificacion_producto = CalificacionProducto::mdlUpdateActivoCalificacionProducto($id_calificacion_producto, $activo);

if (!$calificacion_producto) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo actualizar el campo activo.';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'calificacion_producto', $calificacion_producto, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = $calificacion_producto;

echo json_encode($response);
return;
