<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/calificacion_producto.php';
require '../../modelo/environment.php';
require '../usuario/decodeUsuario.php';
$response = array();

if (
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = $_POST['id_usuario'];
$limite = 10;
$calificaciones = CalificacionProducto::mdlGetCalificacionesByIdUsuario($id_usuario, $limite);

if (!$calificaciones) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron calificaciones de producto';
    echo json_encode($response);
    return;
}

$url_servidor = Environment::getUrlServidor();
$ordenes = array();

foreach ($calificaciones as $key => $calificacion) {
    // Le damos formato a la fecha
    $fecha = date($calificacion['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y", strtotime($fecha));
    $calificaciones[$key]['fecha_alta'] = $fechaFormat;

    // Agregamos la primera imagen del producto y su color de categoria para identificarlo
    if(!is_null($calificacion['imagenes'])){
        $imagenes = json_decode($calificacion['imagenes']);
        $imagenes_url = array();
    
        $calificaciones[$key]['url_imagen'] = $url_servidor . $imagenes[0]->url;
    }

    // Le agregamos la ruta a las imagenes de la calificación
    if($calificacion['imagen_resena'] != null) {
        $imagenes_resena = json_decode($calificacion['imagen_resena']);
        $imagenes_url = array();
        
        foreach ($imagenes_resena as $key_imagen => $value) {
            $imagenes_url[$key_imagen]['id_imagen'] = $value->id_imagen;
            $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $value->url_imagen;
        }
    }

    $calificaciones[$key]['imagen_resena'] = $imagenes_url;
}

$response['response'] = 'success';
$response['data'] = $calificaciones;
echo json_encode($response);
