<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/calificacion_producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    isset($_POST['id_usuario']) &&
    isset($_POST['id_calificacion_producto'])
) {
    $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
    $id_calificacion_producto = $_POST['id_calificacion_producto'];

    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('calificacion_producto', $id_calificacion_producto));

    $calificacion_producto = CalificacionProducto::mdlDeleteCalificacionProducto($id_calificacion_producto);

    if (!$calificacion_producto) {
        $response['response'] = 'error';
        $response['data'] = 'No se eliminó la calificación del producto';
    } else {
        ModeloHistory::mdlAddNewRegister('delete', 'calificacion_producto', $id_calificacion_producto, $id_usuario, $valor_anterior);
        $response['response'] = 'success';
        $response['data'] = 'Calificación del producto eliminada correctamente';
    }

    echo json_encode($response);
    return;
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}