<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/banner.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['banners'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

// Los banners vienen de un stringificado JSON
$banners = json_decode($_POST['banners'], true);

$update = true;
// Iterar sobre cada banner y actualizar su orden
foreach ($banners as $key => $banner) {
    $id_banner = $banner['id_banner'];
    $orden = $banner['orden'];
    // Consultar si ya existe un banner con ese orden
    $exist = Banner::mdlIsBannerOrderExist($id_banner, $orden);
    
    // Si ya existe, saltar al siguiente
    if ($exist) {
        continue;
    }

    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('banner', $id_banner));
    $update = Banner::mdlUpdateOrdenBanner($id_banner, $orden);
    ModeloHistory::mdlAddNewRegister('update', 'banner', $banner['id_banner'], $id_usuario, $valor_anterior);
}


if (!$update) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo actualizar el orden del banner';
    echo json_encode($response);
    return;
}

$response['response'] = 'success';
$response['data'] = $banner;
echo json_encode($response);
