<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/banner.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

// VALIDAR SI LOS CAMPOS EXISTEN
if (!isset(
    $_POST['id_usuario'],
    $_POST['id_banner']
)) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

// VALIDAR SI EXISTE LA IMAGEN
if (!isset($_FILES['imagen']['name'])) {
    $response['response'] = 'error';
    $response['message'] = 'No hay imagen';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

// VALIDAR SI EL USUARIO EXISTE
if (!$id_usuario) {

    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$id_banner = $_POST['id_banner'];

$imagen = $_FILES['imagen']['name'];

$extension = pathinfo($imagen, PATHINFO_EXTENSION);
$nombreImagen = uniqid() . "-" . $id_banner . '.' . $extension;

$imagenRuta = '../../assets/images/banner/' . $nombreImagen;

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('banner', $id_banner));

if (!move_uploaded_file($_FILES['imagen']['tmp_name'], $imagenRuta)) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo subir la imagen';
    echo json_encode($response);
    return;
}

$rutaFinal = "assets/images/banner/" . $nombreImagen;

if (!Banner::mdlUpdateBannerImagen($id_banner, $rutaFinal)) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo actualizar la imagen';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'banner', $id_banner, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = true;
echo json_encode($response);
