<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/banner.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['titulo']) ||
    // !isset($_POST['descripcion']) ||
    // !isset($_POST['url_imagen']) ||
    !isset($_POST['url_destino']) 
    // !isset($_POST['orden'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {

    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$titulo = $_POST['titulo'];
$descripcion = !isset($_POST['descripcion']) ? NULL : $_POST['descripcion'];
$url_imagen = !isset($_POST['url_imagen']) ? NULL : $_POST['url_imagen'];
$url_destino = $_POST['url_destino'];
$orden = NULL;

$last_banner = Banner::mdlGetLastBannerOrder();
$orden = intval($last_banner['orden']) + 1;

$banner = Banner::mdlAddBanner($titulo, $descripcion, $url_imagen, $url_destino, $orden);

if (!$banner) {
    $response['response'] = 'error';
    $response['message'] = 'No se agregó el banner';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'banner', $banner, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $banner;

echo json_encode($response);
return;
