<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/ad_header.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['titulo']) ||
    !isset($_POST['url']) ||
    !isset($_POST['color'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {

    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$titulo = $_POST['titulo'];
$url = $_POST['url'];
$color = $_POST['color'];

$ad_header = AdHeader::mdlAddAdHeader($titulo, $url, $color);

if (!$ad_header) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó el ad_header';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'ad_header', $ad_header, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $ad_header;

echo json_encode($response);
return;