<?php
/**
 * Copyright (c) 2015-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to
 * use, copy, modify, and distribute this software in source code or binary
 * form for use in connection with the web services and APIs provided by
 * Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use
 * of this software is subject to the Facebook Developer Principles and
 * Policies [http://developers.facebook.com/policy/]. This copyright notice
 * shall be included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

namespace FacebookAds\Object\Fields;

use FacebookAds\Enum\AbstractEnum;

/**
 * This class is auto-generated.
 *
 * For any issues or feature requests related to this class, please let us know
 * on github and we'll fix in our codegen framework. We'll not be able to accept
 * pull request for this class.
 *
 */

class ApplicationFields extends AbstractEnum {

  const AAM_RULES = 'aam_rules';
  const AN_AD_SPACE_LIMIT = 'an_ad_space_limit';
  const AN_PLATFORMS = 'an_platforms';
  const ANDROID_KEY_HASH = 'android_key_hash';
  const ANDROID_SDK_ERROR_CATEGORIES = 'android_sdk_error_categories';
  const APP_DOMAINS = 'app_domains';
  const APP_EVENTS_FEATURE_BITMASK = 'app_events_feature_bitmask';
  const APP_EVENTS_SESSION_TIMEOUT = 'app_events_session_timeout';
  const APP_INSTALL_TRACKED = 'app_install_tracked';
  const APP_NAME = 'app_name';
  const APP_SIGNALS_BINDING_IOS = 'app_signals_binding_ios';
  const APP_TYPE = 'app_type';
  const AUTH_DIALOG_DATA_HELP_URL = 'auth_dialog_data_help_url';
  const AUTH_DIALOG_HEADLINE = 'auth_dialog_headline';
  const AUTH_DIALOG_PERMS_EXPLANATION = 'auth_dialog_perms_explanation';
  const AUTH_REFERRAL_DEFAULT_ACTIVITY_PRIVACY = 'auth_referral_default_activity_privacy';
  const AUTH_REFERRAL_ENABLED = 'auth_referral_enabled';
  const AUTH_REFERRAL_EXTENDED_PERMS = 'auth_referral_extended_perms';
  const AUTH_REFERRAL_FRIEND_PERMS = 'auth_referral_friend_perms';
  const AUTH_REFERRAL_RESPONSE_TYPE = 'auth_referral_response_type';
  const AUTH_REFERRAL_USER_PERMS = 'auth_referral_user_perms';
  const AUTO_EVENT_MAPPING_ANDROID = 'auto_event_mapping_android';
  const AUTO_EVENT_MAPPING_IOS = 'auto_event_mapping_ios';
  const AUTO_EVENT_SETUP_ENABLED = 'auto_event_setup_enabled';
  const CANVAS_FLUID_HEIGHT = 'canvas_fluid_height';
  const CANVAS_FLUID_WIDTH = 'canvas_fluid_width';
  const CANVAS_URL = 'canvas_url';
  const CATEGORY = 'category';
  const CLIENT_CONFIG = 'client_config';
  const COMPANY = 'company';
  const CONFIGURED_IOS_SSO = 'configured_ios_sso';
  const CONTACT_EMAIL = 'contact_email';
  const CONTEXT = 'context';
  const CREATED_TIME = 'created_time';
  const CREATOR_UID = 'creator_uid';
  const DAILY_ACTIVE_USERS = 'daily_active_users';
  const DAILY_ACTIVE_USERS_RANK = 'daily_active_users_rank';
  const DEAUTH_CALLBACK_URL = 'deauth_callback_url';
  const DEFAULT_SHARE_MODE = 'default_share_mode';
  const DESCRIPTION = 'description';
  const FINANCIAL_ID = 'financial_id';
  const GDPV4_CHROME_CUSTOM_TABS_ENABLED = 'gdpv4_chrome_custom_tabs_enabled';
  const GDPV4_ENABLED = 'gdpv4_enabled';
  const GDPV4_NUX_CONTENT = 'gdpv4_nux_content';
  const GDPV4_NUX_ENABLED = 'gdpv4_nux_enabled';
  const HAS_MESSENGER_PRODUCT = 'has_messenger_product';
  const HOSTING_URL = 'hosting_url';
  const ICON_URL = 'icon_url';
  const ID = 'id';
  const IOS_BUNDLE_ID = 'ios_bundle_id';
  const IOS_SDK_DIALOG_FLOWS = 'ios_sdk_dialog_flows';
  const IOS_SDK_ERROR_CATEGORIES = 'ios_sdk_error_categories';
  const IOS_SFVC_ATTR = 'ios_sfvc_attr';
  const IOS_SUPPORTS_NATIVE_PROXY_AUTH_FLOW = 'ios_supports_native_proxy_auth_flow';
  const IOS_SUPPORTS_SYSTEM_AUTH = 'ios_supports_system_auth';
  const IPAD_APP_STORE_ID = 'ipad_app_store_id';
  const IPHONE_APP_STORE_ID = 'iphone_app_store_id';
  const LATEST_SDK_VERSION = 'latest_sdk_version';
  const LINK = 'link';
  const LOGGING_TOKEN = 'logging_token';
  const LOGIN_SECRET = 'login_secret';
  const LOGO_URL = 'logo_url';
  const MIGRATIONS = 'migrations';
  const MOBILE_PROFILE_SECTION_URL = 'mobile_profile_section_url';
  const MOBILE_WEB_URL = 'mobile_web_url';
  const MONTHLY_ACTIVE_USERS = 'monthly_active_users';
  const MONTHLY_ACTIVE_USERS_RANK = 'monthly_active_users_rank';
  const NAME = 'name';
  const NAMESPACE = 'namespace';
  const OBJECT_STORE_URLS = 'object_store_urls';
  const PAGE_TAB_DEFAULT_NAME = 'page_tab_default_name';
  const PAGE_TAB_URL = 'page_tab_url';
  const PHOTO_URL = 'photo_url';
  const PRIVACY_POLICY_URL = 'privacy_policy_url';
  const PROFILE_SECTION_URL = 'profile_section_url';
  const PROPERTY_ID = 'property_id';
  const REAL_TIME_MODE_DEVICES = 'real_time_mode_devices';
  const RESTRICTIONS = 'restrictions';
  const RESTRICTIVE_DATA_FILTER_PARAMS = 'restrictive_data_filter_params';
  const RESTRICTIVE_DATA_FILTER_RULES = 'restrictive_data_filter_rules';
  const SDK_UPDATE_MESSAGE = 'sdk_update_message';
  const SEAMLESS_LOGIN = 'seamless_login';
  const SECURE_CANVAS_URL = 'secure_canvas_url';
  const SECURE_PAGE_TAB_URL = 'secure_page_tab_url';
  const SERVER_IP_WHITELIST = 'server_ip_whitelist';
  const SMART_LOGIN_BOOKMARK_ICON_URL = 'smart_login_bookmark_icon_url';
  const SMART_LOGIN_MENU_ICON_URL = 'smart_login_menu_icon_url';
  const SOCIAL_DISCOVERY = 'social_discovery';
  const SUBCATEGORY = 'subcategory';
  const SUGGESTED_EVENTS_SETTING = 'suggested_events_setting';
  const SUPPORTED_PLATFORMS = 'supported_platforms';
  const SUPPORTS_APPREQUESTS_FAST_APP_SWITCH = 'supports_apprequests_fast_app_switch';
  const SUPPORTS_ATTRIBUTION = 'supports_attribution';
  const SUPPORTS_IMPLICIT_SDK_LOGGING = 'supports_implicit_sdk_logging';
  const SUPPRESS_NATIVE_IOS_GDP = 'suppress_native_ios_gdp';
  const TERMS_OF_SERVICE_URL = 'terms_of_service_url';
  const URL_SCHEME_SUFFIX = 'url_scheme_suffix';
  const USER_SUPPORT_EMAIL = 'user_support_email';
  const USER_SUPPORT_URL = 'user_support_url';
  const WEBSITE_URL = 'website_url';
  const WEEKLY_ACTIVE_USERS = 'weekly_active_users';

  public function getFieldTypes() {
    return array(
      'aam_rules' => 'string',
      'an_ad_space_limit' => 'unsigned int',
      'an_platforms' => 'list<string>',
      'android_key_hash' => 'list<string>',
      'android_sdk_error_categories' => 'list<Object>',
      'app_domains' => 'list<string>',
      'app_events_feature_bitmask' => 'unsigned int',
      'app_events_session_timeout' => 'unsigned int',
      'app_install_tracked' => 'bool',
      'app_name' => 'string',
      'app_signals_binding_ios' => 'list<Object>',
      'app_type' => 'unsigned int',
      'auth_dialog_data_help_url' => 'string',
      'auth_dialog_headline' => 'string',
      'auth_dialog_perms_explanation' => 'string',
      'auth_referral_default_activity_privacy' => 'string',
      'auth_referral_enabled' => 'unsigned int',
      'auth_referral_extended_perms' => 'list<string>',
      'auth_referral_friend_perms' => 'list<string>',
      'auth_referral_response_type' => 'string',
      'auth_referral_user_perms' => 'list<string>',
      'auto_event_mapping_android' => 'list<Object>',
      'auto_event_mapping_ios' => 'list<Object>',
      'auto_event_setup_enabled' => 'bool',
      'canvas_fluid_height' => 'bool',
      'canvas_fluid_width' => 'unsigned int',
      'canvas_url' => 'string',
      'category' => 'string',
      'client_config' => 'map',
      'company' => 'string',
      'configured_ios_sso' => 'bool',
      'contact_email' => 'string',
      'context' => 'Object',
      'created_time' => 'datetime',
      'creator_uid' => 'string',
      'daily_active_users' => 'string',
      'daily_active_users_rank' => 'unsigned int',
      'deauth_callback_url' => 'string',
      'default_share_mode' => 'string',
      'description' => 'string',
      'financial_id' => 'string',
      'gdpv4_chrome_custom_tabs_enabled' => 'bool',
      'gdpv4_enabled' => 'bool',
      'gdpv4_nux_content' => 'string',
      'gdpv4_nux_enabled' => 'bool',
      'has_messenger_product' => 'bool',
      'hosting_url' => 'string',
      'icon_url' => 'string',
      'id' => 'string',
      'ios_bundle_id' => 'list<string>',
      'ios_sdk_dialog_flows' => 'Object',
      'ios_sdk_error_categories' => 'list<Object>',
      'ios_sfvc_attr' => 'bool',
      'ios_supports_native_proxy_auth_flow' => 'bool',
      'ios_supports_system_auth' => 'bool',
      'ipad_app_store_id' => 'string',
      'iphone_app_store_id' => 'string',
      'latest_sdk_version' => 'Object',
      'link' => 'string',
      'logging_token' => 'string',
      'login_secret' => 'string',
      'logo_url' => 'string',
      'migrations' => 'map<string, bool>',
      'mobile_profile_section_url' => 'string',
      'mobile_web_url' => 'string',
      'monthly_active_users' => 'string',
      'monthly_active_users_rank' => 'unsigned int',
      'name' => 'string',
      'namespace' => 'string',
      'object_store_urls' => 'Object',
      'page_tab_default_name' => 'string',
      'page_tab_url' => 'string',
      'photo_url' => 'string',
      'privacy_policy_url' => 'string',
      'profile_section_url' => 'string',
      'property_id' => 'string',
      'real_time_mode_devices' => 'list<string>',
      'restrictions' => 'Object',
      'restrictive_data_filter_params' => 'string',
      'restrictive_data_filter_rules' => 'string',
      'sdk_update_message' => 'string',
      'seamless_login' => 'int',
      'secure_canvas_url' => 'string',
      'secure_page_tab_url' => 'string',
      'server_ip_whitelist' => 'string',
      'smart_login_bookmark_icon_url' => 'string',
      'smart_login_menu_icon_url' => 'string',
      'social_discovery' => 'unsigned int',
      'subcategory' => 'string',
      'suggested_events_setting' => 'string',
      'supported_platforms' => 'list<SupportedPlatforms>',
      'supports_apprequests_fast_app_switch' => 'Object',
      'supports_attribution' => 'bool',
      'supports_implicit_sdk_logging' => 'bool',
      'suppress_native_ios_gdp' => 'bool',
      'terms_of_service_url' => 'string',
      'url_scheme_suffix' => 'string',
      'user_support_email' => 'string',
      'user_support_url' => 'string',
      'website_url' => 'string',
      'weekly_active_users' => 'string',
    );
  }
}
