<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once('./../modelo/odoo_orden_venta.php');
require_once('./../modelo/odoo_cliente.php');
require_once('./../modelo/odoo_inventario.php');
require_once('./../modelo/odoo_producto.php');

// 1. Obtenemos el id del almacen donde se obtendran los productos
$datawarehouse = OdooInventario::getAlmacenesId();
$id_almacen = $datawarehouse[0]['id'];

$id_client = OdooCliente::getClientIdByRFCOrEmail(null, "soporte@cursodontic.com");

// 2. Creamos una nueva orden de venta en Odoo
$sale_order_id = OdooOrdenVenta::addNewSaleOrder($id_client, $id_almacen);
echo "sale_order_id: $sale_order_id\n";

// Agregaremos un producto de cada elemento la lista de productos 'versaprink'
$tag_id = OdooProducto::getProductTagId('versaprink');
$produdctos = OdooProducto::searchProducts($tag_id);

$products = array();
foreach($produdctos as $product){
    $products[] = array(
        'id' => $product['id'],
        'qty' => 1
    );
}

// 3. Agregamos los productos a la orden de venta
foreach($products as $product){
    if($product['qty'] > 0){
        $sale_order_line_id = OdooOrdenVenta::addNewLineToSaleOrder($sale_order_id, $product['id'], $product['qty']);
        print_r($sale_order_line_id);
        echo "\n";
    }
}

// 4. Confirmamos la orden de venta
$sale_order_confirm = OdooOrdenVenta::confirmSaleOrder($sale_order_id);
print_r("sale_order_confirm: $sale_order_confirm\n");

// 5. Agregamos el mensaje personalizado a la orden de picking
$message_id = OdooOrdenVenta::addNoteToOrder(
    $sale_order_id, 
    'Esta es una nota de prueba -> $nombre, $calle, $calle2, $ciudad, $cp, $rfc, $telefono, $email, $nombre_empresa, $id_estado, $id_pais'
);

echo $message_id;
echo "\n";

// 9. Facturar automáticamente la orden de la venta
$id_factura = OdooOrdenVenta::createInvoiceFromAdvancePayment($sale_order_id);
echo "id_factura: ";
print_r($id_factura);

// 10. Obtener el id de la factura de la orden de venta
$confirmar_factura = OdooOrdenVenta::getInvoiceIDsAndConfirmBySaleOrderID($sale_order_id);
echo "confirmar_factura: ";
print_r($confirmar_factura);