<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once('./../modelo/odoo_orden_venta.php');
require_once('./../modelo/odoo_cliente.php');
require_once('./../modelo/odoo_inventario.php');
// require_once('./../modelo/odoo_producto.php');
require_once('./../modelo/direccion_facturacion.php');

// DATA DE PRUEBA 
$data_almacenes = [
    "zona_extendida" => [
        "zona_extendida_cantidad" => 2,
        "id_zona_extendida_odoo" => "7"
    ],
    "control_envio" => [
        [
            "peso_total" => 7.65,
            "id_almacen" => 5,
            "id_lot_stock" => 36,
            "nombre_almacen" => "Monterrey",
            "productos" => [
                // [
                //     "id_producto_odoo" => "2",
                //     "id_precio_odoo" => 1,
                //     "cantidad" => 1,
                //     "peso" => 7.5
                // ],
                [
                    "id_producto_odoo" => "1",
                    "id_precio_odoo" => null,
                    "cantidad" => 1,
                    "peso" => 0.15
                ]
            ],
            "id_producto_guia_envio" => 5
        ],
        [
            "peso_total" => 7.5,
            "id_almacen" => 1,
            "id_lot_stock" => 8,
            "nombre_almacen" => "Matriz",
            "productos" => [
                [
                    "id_producto_odoo" => "2",
                    "id_precio_odoo" => null,
                    "cantidad" => 1,
                    "peso" => 7.5
                ]
            ],
            "id_producto_guia_envio" => 5
        ]
    ]
];

// Obtenemos todos los datos que se van a necesitar para dar de alta una orden correctamente
$id_lot_stock_almacen_virtual = 42;
$id_almacen_virtual = 6;
$id_usuario = $_POST['id_usuario'] ?? null;
$id_usuario_odoo = $_POST['id_usuario_odoo'] ?? null;
$id_direccion_envio = $_POST['id_direccion_envio'] ?? null;
$id_direccion_factura = $_POST['id_direccion_factura'] ?? null; // Es opcional
$cupon = $_POST['cupon'] ?? null; // Es opcional

// 1. Verificamos si el usuario solicito factura en este pedido
// Si no la solicitó, tenemos que asignarle la venta a un RFC genérico de Odoo, que lo tiene un cliente llamado 'Versa Prink'
if (is_null($id_direccion_factura)) {
    $id_cliente_generico = "11"; // ID del cliente genérico de Odoo hardcodeado
    // $id_cliente_generico = OdooCliente::getClientIdByRFCOrEmail('XAXX010101000', null);
    $id_cliente = $id_cliente_generico;
} else {
    // Si solicitó factura, obtenemos el ID del cliente que solicitó la factura
    $id_cliente = $id_usuario_odoo;
}

// 2. Verificar si el pedido sale de un almacén.
$almacenes = $data_almacenes['control_envio'];
$total_almacenes = count($almacenes);
$id_almacen_salida = null;

// Si sale de mas de un almacen, hay que mover todos los productos al almacen virtual
if($total_almacenes > 1){
    $id_almacen_salida = $id_lot_stock_almacen_virtual;
    $id_almacen = $id_almacen_virtual;
    // Mover todos los productos al almacen virtual
    foreach ($almacenes as $almacen) {
        $id_lot_stock = intval($almacen['id_lot_stock']);
        $productos = $almacen['productos'];
        foreach ($productos as $producto) {
            $id_producto = intval($producto['id_producto_odoo']);
            $cantidad = intval($producto['cantidad']);
            $id = OdooInventario::moveProductBetweenWarehouses($id_producto, $id_lot_stock, $id_lot_stock_almacen_virtual, $cantidad);
            print_r($id);
        }
    }
} else {
    $id_almacen_salida = $almacenes[0]['id_lot_stock'];
    $id_almacen = $almacenes[0]['id_almacen'];
}

// $id = OdooCliente::getDireccionesFacturacion($id_cliente);
// print_r($id);

// 3. Crear la orden de venta en Odoo
$sale_order_id = OdooOrdenVenta::addNewSaleOrder($id_cliente, $id_almacen);
print_r($sale_order_id);
echo "\n";

// 4. Agregar los productos a la orden de venta
foreach ($almacenes as $almacen) {
    $productos = $almacen['productos'];
    foreach ($productos as $producto) {
        $id_producto = intval($producto['id_producto_odoo']);
        $cantidad = intval($producto['cantidad']);
        $id = OdooOrdenVenta::addNewLineToSaleOrder($sale_order_id, $id_producto, $cantidad);
        print_r($id);
        echo "\n";
    }
}

// 4.1 Verificar el precio que se utilizó para cobrar el producto y asignarlo a la orden de venta

// 5. Agregar el id del producto/servicio de la guia de envio a la orden de venta, dependiendo cada almacen
foreach ($almacenes as $almacen) {
    $id_producto_guia_envio = $almacen['id_producto_guia_envio'];
    $id = OdooOrdenVenta::addNewLineToSaleOrder($sale_order_id, $id_producto_guia_envio, 1);
    print_r($id);
    echo "\n";
}

// 6. Agregamos la cuenta analítica a la orden de venta
$sales_team_id = 5; // Es la cuenta analítica de Versa Prink
$account_analytic_id = OdooOrdenVenta::assignSalesTeamToSaleOrder($sale_order_id, $sales_team_id);
echo "account_analytic_id: ";
print_r($account_analytic_id);

// 7. Confirmar la orden de venta
$sale_order_confirm = OdooOrdenVenta::confirmSaleOrder($sale_order_id);

// 8. Agregamos el mensaje personalizado a la orden de picking
$message_id = OdooOrdenVenta::addNoteToOrder(
    $sale_order_id, 
    'Esta es una nota de prueba -> Aqui debe de ir la direccion de envio del usuario'
);

echo "message_id: " . $message_id . "\n";


// 9. Facturar automáticamente la orden de la venta
$id_factura = OdooOrdenVenta::createInvoiceFromAdvancePayment($sale_order_id);
echo "id_factura: ";
print_r($id_factura);

// 10. Obtener el id de la factura de la orden de venta
$confirmar_factura = OdooOrdenVenta::getInvoiceIDsAndConfirmBySaleOrderID($sale_order_id);
echo "confirmar_factura: ";
print_r($confirmar_factura);