<?php

require_once 'conexion.php';

class Usuario
{

    // MODELOS AGREGADOS PARA ADMINISTRACION

    public static function mdlSearchTotal($filtros, $terminoBusqueda)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();

        // Agregamos a los fitrlos el id_tipo_usuario = 2
        $filtros[] = array('campo' => 'id_tipo_usuario', 'data' => array('id_tipo_usuario' => 2));

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "estado") {
                    $sqlFiltro .= "usuario.activo = " . $filtro['data']['activo'];
                }

                if ($campo == "id_tipo_usuario") {
                    $sqlFiltro .= "usuario.id_tipo_usuario = " . $filtro['data']['id_tipo_usuario'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(usuario.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(usuario.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND usuario.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "usuario.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "usuario.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "usuario.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "usuario.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno) LIKE ? OR 
                usuario.nombre LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT DISTINCT COUNT(*) as total FROM usuario 
                 " . $sqlTotal;
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
    }

    public static function mdlSearchLimit($filtros, $terminoBusqueda, $orden, $offset, $limit)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();
        $sqlOrden = '';

        // Agregamos a los fitrlos el id_tipo_usuario = 2
        $filtros[] = array('campo' => 'id_tipo_usuario', 'data' => array('id_tipo_usuario' => 2));

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "estado") {
                    $sqlFiltro .= "usuario.activo = " . $filtro['data']['activo'];
                }

                if ($campo == "id_tipo_usuario") {
                    $sqlFiltro .= "usuario.id_tipo_usuario = " . $filtro['data']['id_tipo_usuario'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(usuario.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(usuario.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND usuario.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "usuario.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "usuario.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "usuario.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "usuario.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno) LIKE ? OR 
                usuario.nombre LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        if ($orden != NULL) {
            // AQUI VA EL QUERY PARA EL TERMINO DE LA ORDEN
            if ($orden['campo'] == 'nombre')
                $sqlOrden .= ' ORDER BY usuario.nombre ' . $orden['orden'];
            if ($orden['campo'] == 'fecha_alta')
                $sqlOrden .= ' ORDER BY usuario.fecha_alta ' . $orden['orden'];
        } else {
            $sqlOrden .= ' ORDER BY usuario.id_usuario DESC';
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT usuario.* FROM usuario 
                 " . $sqlTotal . " " . $sqlOrden . " LIMIT " . $offset . ", " . $limit;
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
    }

    public static function mdlGetAllUsuariosClientes()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM usuario WHERE id_tipo_usuario = 2";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $result = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        // Cerrar la conexión
        $db = null;
        return $result;
    }

    public static function mdlAddUsuarioAdministracion($nombre, $apellido_paterno, $apellido_materno, $correo, $password, $pais, $user_agent, $ip)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO usuario (id_tipo_usuario, nombre, apellido_paterno, apellido_materno, correo, password, pais, user_agent, ip) VALUES (:id_tipo_usuario, :nombre, :apellido_paterno, :apellido_materno, :correo, :password, :pais, :user_agent, :ip)";

        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);
        $db->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

        $stmt = $db->prepare($sql);

        $id_tipo_usuario = 1;
        $stmt->bindParam(':id_tipo_usuario', $id_tipo_usuario);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':apellido_paterno', $apellido_paterno);
        $stmt->bindParam(':apellido_materno', $apellido_materno);
        $stmt->bindParam(':correo', $correo);
        $stmt->bindParam(':password', $password);
        $stmt->bindParam(':pais', $pais);
        $stmt->bindParam(':user_agent', $user_agent);
        $stmt->bindParam(':ip', $ip);

        $stmt->execute();
        $result = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;
        $db = null;
        return $result;
    }

    public static function mdlBuscarByFiltrosTerminoOrden($filtros, $terminoBusqueda, $orden)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();
        $sqlOrden = '';

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "estado") {
                    $sqlFiltro .= "usuario.activo = " . $filtro['data']['activo'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(usuario.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(usuario.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND usuario.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "usuario.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "usuario.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "usuario.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "usuario.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                usuario.correo LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        if ($orden != NULL) {
            // AQUI VA EL QUERY PARA EL TERMINO DE LA ORDEN
            if ($orden['campo'] == 'nombre')
                $sqlOrden .= ' ORDER BY usuario.nombre ' . $orden['orden'];
            if ($orden['campo'] == 'fecha_alta')
                $sqlOrden .= ' ORDER BY usuario.fecha_alta ' . $orden['orden'];
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // Agregar la sentencia id_tipo_usuario = 1 al WHERE
        if ($sqlTotal != '')
            $sqlTotal .= ' AND id_tipo_usuario = 1';
        else
            $sqlTotal .= 'WHERE id_tipo_usuario = 1';

        // ////////////////////////////////////////////////////////////////////////

        $sql =
            "SELECT * FROM usuario "
            . $sqlTotal . " " . $sqlOrden;
        // return $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        $result = ($stmt->rowCount() >= 1) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        $db = null;
        return $result;
    }

    public static function mdlGetUsuariosAdministracion()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM usuario WHERE id_tipo_usuario = 1";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $result = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        // Cerrar la conexión
        $db = null;
        return $result;
    }

    public static function mdlGetUsuariosAdministracionActivo($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM usuario WHERE activo = :activo and id_tipo_usuario = 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':activo', $activo);
        $stmt->execute();
        $result = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        // Cerrar la conexión
        $db = null;
        return $result;
    }

    // FIN DE MODELOS PARA ADMINISTRACION

    public static function mdlAddUsuario($id_usuario_odoo, $nombre, $apellido_paterno, $apellido_materno, $correo, $celular, $password, $fecha_nacimiento, $id_sexo, $pais, $user_agent, $ip, $uid_google, $uid_facebook)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO usuario (id_usuario_odoo, nombre, apellido_paterno, apellido_materno, correo, celular, password, fecha_nacimiento, id_sexo, pais, user_agent, ip, uid_google, uid_facebook) VALUES (:id_usuario_odoo, :nombre, :apellido_paterno, :apellido_materno, :correo, :celular, :password, :fecha_nacimiento, :id_sexo, :pais, :user_agent, :ip, :uid_google, :uid_facebook)";

        // $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        // $db->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario_odoo', $id_usuario_odoo);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':apellido_paterno', $apellido_paterno);
        $stmt->bindParam(':apellido_materno', $apellido_materno);
        $stmt->bindParam(':correo', $correo);
        $stmt->bindParam(':celular', $celular);
        $stmt->bindParam(':password', $password);
        $stmt->bindParam(':fecha_nacimiento', $fecha_nacimiento);
        $stmt->bindParam(':id_sexo', $id_sexo);
        $stmt->bindParam(':pais', $pais);
        $stmt->bindParam(':user_agent', $user_agent);
        $stmt->bindParam(':ip', $ip);
        $stmt->bindParam(':uid_google', $uid_google);
        $stmt->bindParam(':uid_facebook', $uid_facebook);

        $stmt->execute();

        $response = ($stmt) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateUsuarioFotoPerfil($id_usuario, $foto_perfil)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE usuario SET foto_perfil = :foto_perfil WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':foto_perfil', $foto_perfil);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateUsuarioGeneral($id_usuario, $nombre, $apellido_paterno, $apellido_materno, $correo, $celular, $fecha_nacimiento, $id_sexo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE usuario SET nombre = :nombre, apellido_paterno = :apellido_paterno, apellido_materno = :apellido_materno, correo = :correo, celular = :celular, fecha_nacimiento = :fecha_nacimiento, id_sexo = :id_sexo WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':apellido_paterno', $apellido_paterno);
        $stmt->bindParam(':apellido_materno', $apellido_materno);
        $stmt->bindParam(':correo', $correo);
        $stmt->bindParam(':celular', $celular);
        $stmt->bindParam(':fecha_nacimiento', $fecha_nacimiento);
        $stmt->bindParam(':id_sexo', $id_sexo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateUsuarioById($id_usuario, $nombre, $apellido_paterno, $apellido_materno, $celular, $fecha_nacimiento, $id_sexo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE usuario SET nombre = :nombre, apellido_paterno = :apellido_paterno, apellido_materno = :apellido_materno, celular = :celular, fecha_nacimiento = :fecha_nacimiento, id_sexo = :id_sexo WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);
        $db->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':apellido_paterno', $apellido_paterno);
        $stmt->bindParam(':apellido_materno', $apellido_materno);
        $stmt->bindParam(':celular', $celular);
        $stmt->bindParam(':fecha_nacimiento', $fecha_nacimiento);
        $stmt->bindParam(':id_sexo', $id_sexo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateUsuarioIdOdoo($id_usuario, $id_usuario_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE usuario SET id_usuario_odoo = :id_usuario_odoo WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':id_usuario_odoo', $id_usuario_odoo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }


    public static function mdlGetUsuarioActivo($id_usuario, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM usuario WHERE id_usuario = :id_usuario AND activo = :activo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':activo', $activo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetUsuarioByCorreo($correo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM usuario WHERE correo = :correo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':correo', $correo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetUsuarioById($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM usuario WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetUsuarioIdOdoo($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT id_usuario_odoo FROM usuario WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC)['id_usuario_odoo'] : false;

        $db = null;

        return $response;
    }

    public static function mdlGetUsuarioRegistro($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT nombre, apellido_paterno, apellido_materno, correo, foto_perfil FROM usuario WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateActivoUsuario($id_usuario, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE usuario SET activo = :activo WHERE id_usuario = :id_usuario";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':activo', $activo);
        $stmt->execute();
        $result = ($stmt->rowCount() > 0) ? true : false;
        $db = null;
        return $result;
    }

    public static function mdlLoginUsuarioByEmail($correo, $password)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT id_usuario, nombre, apellido_paterno, apellido_materno, correo, password, foto_perfil FROM usuario WHERE correo = :correo AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':correo', $correo);

        $stmt->execute();

        $usuario = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        if (!$usuario) {
            return false;
        }

        if (!password_verify($password, $usuario['password'])) {
            return false;
        }

        return $usuario;
    }

    public static function mdlLoginUsuarioAdministradorByEmail($correo, $password)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql =
            "SELECT usuario.* 
        FROM usuario left join tipo_usuario on usuario.id_tipo_usuario = tipo_usuario.id_tipo_usuario
        WHERE usuario.correo = :correo AND usuario.activo = 1 AND tipo_usuario.nombre = 'administrador'";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':correo', $correo);

        $stmt->execute();

        $usuario = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        if (!$usuario) {
            return false;
        }

        if (!password_verify($password, $usuario['password'])) {
            return false;
        }

        return $usuario;
    }

    public static function mdlVerifyUsuarioPassword($id_usuario, $password)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM usuario WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);

        $stmt->execute();

        $usuario = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        if (!$usuario) {
            return false;
        }

        if (!password_verify($password, $usuario['password'])) {
            return false;
        }

        return $usuario;
    }

    public static function mdlUpdateUsuarioPassword($id_usuario, $password)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE usuario SET password = :password, codigo_recover_password = NULL WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':password', $password);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlCodigoAleatorioRecuperarPassword($correo, $codigo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE usuario SET codigo_recover_password = :codigo_recover_password, date_recover_password = CURRENT_DATE() WHERE correo = :correo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':correo', $correo);
        $stmt->bindParam(':codigo_recover_password', $codigo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $codigo : false;

        $db = null;

        return $response;
    }

    public static function mdlVerifyCodigoAleatorio($id_usuario, $codigo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM usuario WHERE id_usuario = :id_usuario AND codigo_recover_password = :codigo_recover_password AND date_recover_password = CURRENT_DATE()";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':codigo_recover_password', $codigo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlVerifyUsuarioExistente($correo, $celular)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM usuario WHERE correo = :correo OR celular = :celular";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':correo', $correo);
        $stmt->bindParam(':celular', $celular);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlVerifyUsuarioGoogle($correo, $uid)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT id_usuario, nombre, apellido_paterno, apellido_materno, correo, password, foto_perfil FROM usuario WHERE correo = :correo AND uid_google = :uid OR uid_facebook = :uid";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':correo', $correo);
        $stmt->bindParam(':uid', $uid);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlExisteUsuarioByCorreo($correo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM usuario WHERE correo = :correo";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':correo', $correo);
        $stmt->execute();
        $result = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
        $db = null;
        return $result;
    }

    public static function mdlUpdateCustomerIdOpenpay($id_usuario, $customer_id)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE usuario SET id_cliente_openpay = :id_cliente_openpay WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':id_cliente_openpay', $customer_id);

        $stmt->execute();
        $result = ($stmt->rowCount() > 0) ? true : false;
        $db = null;
        return $result;
    }
}
