<?php

require_once 'conexion.php';

class TipoVariacion
{
    public static function mdlGetTiposVariaciones()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM tipo_variacion";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetTipoVariacionById($id_tipo_variacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM tipo_variacion WHERE id_tipo_variacion = :id_tipo_variacion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_tipo_variacion", $id_tipo_variacion);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddTipoVariacion($nombre_variacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO tipo_variacion (nombre_variacion) VALUES (:nombre_variacion)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre_variacion", $nombre_variacion);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateTipoVariacion($id_tipo_variacion, $nombre_variacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE tipo_variacion SET nombre_variacion = :nombre_variacion WHERE id_tipo_variacion = :id_tipo_variacion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre_variacion", $nombre_variacion);
        $stmt->bindParam(":id_tipo_variacion", $id_tipo_variacion);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteTipoVariacion($id_tipo_variacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM tipo_variacion WHERE id_tipo_variacion = :id_tipo_variacion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_tipo_variacion", $id_tipo_variacion);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }
}
