<?php

require_once 'conexion.php';

class Subcategoria
{

    public static function mdlGetSubcategoriasActivoByIdCategoria($id_categoria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM subcategoria WHERE id_categoria = :id_categoria AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_categoria', $id_categoria);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetSubcategorias()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM subcategoria WHERE activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetSubcategoriaById($id_subcategoria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM subcategoria WHERE id_subcategoria = :id_subcategoria AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_subcategoria', $id_subcategoria);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddSubcategoria($id_categoria, $nombre, $descripcion, $imagen, $url_pagina)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO subcategoria (id_categoria, nombre, descripcion, imagen, url_pagina) VALUES (:id_categoria, :nombre, :descripcion, :imagen, :url_pagina)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_categoria', $id_categoria);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':imagen', $imagen);
        $stmt->bindParam(':url_pagina', $url_pagina);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateSubcategoria($id_subcategoria, $id_categoria, $nombre, $descripcion, $url_pagina)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE subcategoria SET id_categoria = :id_categoria, nombre = :nombre, descripcion = :descripcion, url_pagina = :url_pagina WHERE id_subcategoria = :id_subcategoria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_subcategoria', $id_subcategoria);
        $stmt->bindParam(':id_categoria', $id_categoria);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':url_pagina', $url_pagina);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateSubcategoriaImagen($id_subcategoria, $imagen)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE subcategoria SET imagen = :imagen WHERE id_subcategoria = :id_subcategoria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_subcategoria', $id_subcategoria);
        $stmt->bindParam(':imagen', $imagen);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteSubcategoria($id_subcategoria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM subcategoria WHERE id_subcategoria = :id_subcategoria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_subcategoria', $id_subcategoria);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetAllSubcategoriasByCategoria($id_categoria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql =
            "SELECT subcategoria.*, categoria.url_pagina as url_pagina_categoria, categoria.id_categoria
            FROM subcategoria left join categoria on subcategoria.id_categoria = categoria.id_categoria 
            WHERE subcategoria.id_categoria = :id_categoria 
            ORDER BY subcategoria.id_subcategoria DESC";
        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_categoria', $id_categoria);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        $db = null;

        return $response;
    }

    public static function mdlGetSubcategoriaByCategoria($id_categoria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT subcategoria.* FROM `subcategoria`
                WHERE subcategoria.id_categoria = :id_categoria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_categoria', $id_categoria);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetSubcategoriaByCategoriaActivo($id_categoria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM subcategoria WHERE id_categoria = :id_categoria AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_categoria', $id_categoria);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    // public static function mdlGetSubcategoriaByCategoria($id_categoria)
    // {
    //     $conexion = new Conexion();
    //     $db = $conexion->get_connection();

    //     $sql = "SELECT subcategoria.* FROM `producto_categoria`
    //             INNER JOIN subcategoria ON producto_categoria.id_subcategoria = subcategoria.id_subcategoria
    //             WHERE producto_categoria.id_categoria = :id_categoria
    //             GROUP BY producto_categoria.id_subcategoria";

    //     $stmt = $db->prepare($sql);

    //     $stmt->bindParam(':id_categoria', $id_categoria);

    //     $stmt->execute();

    //     $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

    //     $db = null;

    //     return $response;
    // }

    public static function mdlUpdateActivoSubcategoria($id_subcategoria, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE subcategoria SET activo = :activo WHERE id_subcategoria = :id_subcategoria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_subcategoria', $id_subcategoria);
        $stmt->bindParam(':activo', $activo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetSubcategoriaByNombreCategoria($url_pagina)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT subcategoria.*, categoria.color FROM subcategoria
                INNER JOIN categoria ON subcategoria.id_categoria = categoria.id_categoria 
                WHERE categoria.url_pagina = :url_pagina 
                AND subcategoria.activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':url_pagina', $url_pagina);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetSubcategoriaByNombres($categoria, $subcategoria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT subcategoria.*, categoria.nombre as nombre_categoria
        FROM subcategoria left join categoria on subcategoria.id_categoria = categoria.id_categoria
        WHERE subcategoria.url_pagina = :subcategoria AND categoria.url_pagina = :categoria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':categoria', $categoria);
        $stmt->bindParam(':subcategoria', $subcategoria);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
