<?php
require_once 'conexion.php';

class RegimenSat
{
    public static function mdlGetRegimenesSat()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM regimenes_sat";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddRegimenSat($clave_regimen_fiscal, $descripcion, $tipo_persona)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO regimenes_sat (clave_regimen_fiscal, descripcion, tipo_persona) VALUES (:clave_regimen_fiscal, :descripcion, :tipo_persona)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":clave_regimen_fiscal", $clave_regimen_fiscal, PDO::PARAM_INT);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":tipo_persona", $tipo_persona);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateRegimenSat($id_regimen_sat, $clave_regimen_fiscal, $descripcion, $tipo_persona)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE regimenes_sat SET clave_regimen_fiscal = :clave_regimen_fiscal, descripcion = :descripcion, tipo_persona = :tipo_persona WHERE id_regimen_sat = :id_regimen_sat";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":clave_regimen_fiscal", $clave_regimen_fiscal, PDO::PARAM_INT);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":tipo_persona", $tipo_persona);
        $stmt->bindParam(":id_regimen_sat", $id_regimen_sat, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteRegimenSat($id_regimen_sat)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM regimenes_sat WHERE id_regimen_sat = :id_regimen_sat";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_regimen_sat", $id_regimen_sat, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetRegimenesSatByNombre($nombre)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM regimenes_sat WHERE clave_regimen_fiscal = :nombre";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
?>