<?php

require_once 'conexion.php';

class ReclamoDevolucion
{
    public static function mdlAddReclamoDevolucion($id_usuario, $id_orden, $id_estado_reclamo, $motivo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO reclamo_devolucion (id_usuario, id_orden, id_estado_reclamo, motivo) VALUES (:id_usuario, :id_orden, :id_estado_reclamo, :motivo)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':id_orden', $id_orden, PDO::PARAM_INT);
        $stmt->bindParam(':id_estado_reclamo', $id_estado_reclamo, PDO::PARAM_INT);
        $stmt->bindParam(':motivo', $motivo, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetReclamoDevolucion($id_reclamo_devolucion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT reclamo_devolucion.*, estado_reclamo.nombre as estado_reclamo_nombre, estado_reclamo.descripcion as estado_reclamo_descripcion
                FROM reclamo_devolucion
                INNER JOIN estado_reclamo ON reclamo_devolucion.id_estado_reclamo = estado_reclamo.id_estado_reclamo 
                WHERE reclamo_devolucion.id_reclamo_devolucion = :id_reclamo_devolucion";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_reclamo_devolucion', $id_reclamo_devolucion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetReclamosDevolucionByUsuario($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT reclamo_devolucion.*, estado_reclamo.nombre as estado_reclamo_nombre, estado_reclamo.descripcion as estado_reclamo_descripcion
                FROM reclamo_devolucion
                INNER JOIN estado_reclamo ON reclamo_devolucion.id_estado_reclamo = estado_reclamo.id_estado_reclamo 
                WHERE reclamo_devolucion.id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetReclamosDevolucion()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT reclamo_devolucion.*, estado_reclamo.nombre as estado_reclamo_nombre, estado_reclamo.descripcion as estado_reclamo_descripcion
                FROM reclamo_devolucion
                INNER JOIN estado_reclamo ON reclamo_devolucion.id_estado_reclamo = estado_reclamo.id_estado_reclamo";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetReclamosDevolucionByEstado($id_estado_reclamo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT reclamo_devolucion.*, estado_reclamo.nombre as estado_reclamo_nombre, estado_reclamo.descripcion as estado_reclamo_descripcion
                FROM reclamo_devolucion
                INNER JOIN estado_reclamo ON reclamo_devolucion.id_estado_reclamo = estado_reclamo.id_estado_reclamo 
                WHERE reclamo_devolucion.id_estado_reclamo = :id_estado_reclamo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_estado_reclamo', $id_estado_reclamo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateReclamoDevolucion($id_reclamo_devolucion, $id_usuario, $id_orden, $id_estado_reclamo, $motivo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE reclamo_devolucion SET id_usuario = :id_usuario, id_orden = :id_orden, id_estado_reclamo = :id_estado_reclamo, motivo = :motivo WHERE id_reclamo_devolucion = :id_reclamo_devolucion";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_reclamo_devolucion', $id_reclamo_devolucion, PDO::PARAM_INT);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':id_orden', $id_orden, PDO::PARAM_INT);
        $stmt->bindParam(':id_estado_reclamo', $id_estado_reclamo, PDO::PARAM_INT);
        $stmt->bindParam(':motivo', $motivo, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateEstadoReclamoDevolucion($id_reclamo_devolucion, $id_estado_reclamo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE reclamo_devolucion SET id_estado_reclamo = :id_estado_reclamo WHERE id_reclamo_devolucion = :id_reclamo_devolucion";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_reclamo_devolucion', $id_reclamo_devolucion, PDO::PARAM_INT);
        $stmt->bindParam(':id_estado_reclamo', $id_estado_reclamo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteReclamoDevolucion($id_reclamo_devolucion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM reclamo_devolucion WHERE id_reclamo_devolucion = :id_reclamo_devolucion";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_reclamo_devolucion', $id_reclamo_devolucion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}
