<?php

require_once 'environment.php';
error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);
class Pak2Go
{
    public static function checkPrices($data)
    {
        $apiKey = Environment::getPak2goKey();
        $url = "https://pak-sandbox.pak2go.digital/v1/quotations";

        $ch = curl_init($url);

        $jsonData = json_encode($data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Authorization: Token token=" . $apiKey,
            "Content-Type: application/json"
        ));

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30); // Set timeout to 30 seconds

        $response = curl_exec($ch);

        if ($response === false) {
            throw new Exception("cURL error: " . curl_error($ch));
        }

        curl_close($ch);

        return json_decode($response, true); // Return response as associative array
    }

    public static function getShipments()
    {
        $apiKey = Environment::getPak2goKey();
        $url = "https://pak-sandbox.pak2go.digital/v1/shipments";

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Authorization: Token token=" . $apiKey,
            "Content-Type: application/json"
        ));

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30); // Set timeout to 30 seconds

        $response = curl_exec($ch);

        if ($response === false) {
            throw new Exception("cURL error: " . curl_error($ch));
        }

        curl_close($ch);

        return json_decode($response, true); // Return response as associative array
    }

    public static function getSpecificShipment($shipment_id)
    {
        $apiKey = Environment::getPak2goKey();
        $url = "https://pak-sandbox.pak2go.digital/v1/shipments/" . $shipment_id;

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Authorization: Token token=" . $apiKey,
            "Content-Type: application/json"
        ));

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30); // Set timeout to 30 seconds

        $response = curl_exec($ch);

        if ($response === false) {
            throw new Exception("cURL error: " . curl_error($ch));
        }

        curl_close($ch);

        return json_decode($response, true); // Return response as associative array
    }

    // public static function createShipment($address_from, $address_to, $parcels) {
    public static function createShipment($data)
    {
        $apiKey = Environment::getPak2goKey();
        $url = "https://pak-sandbox.pak2go.digital/v1/shipments";

        $ch = curl_init($url);

        $jsonData = json_encode($data);

        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Authorization: Token token=" . $apiKey,
            "Content-Type: application/json"
        ));

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30); // Set timeout to 30 seconds

        $response = curl_exec($ch);

        if ($response === false) {
            throw new Exception("cURL error: " . curl_error($ch));
        }

        curl_close($ch);

        return json_decode($response, true); // Return response as associative array
    }

    public static function generateGuide($shipment_id)
    {
        $apiKey = Environment::getPak2goKey();
        $url = "https://pak-sandbox.pak2go.digital/v1/labels";

        $ch = curl_init($url);

        $jsonData = json_encode($shipment_id);
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Authorization: Token token=" . $apiKey,
            "Content-Type: application/json"
        ));

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30); // Set timeout to 30 seconds

        $response = curl_exec($ch);

        if ($response === false) {
            throw new Exception("cURL error: " . curl_error($ch));
        }

        curl_close($ch);

        return json_decode($response, true); // Return response as associative array
    }
}
