<?php

require_once 'odoo_auth.php';

class OdooCliente
{
    public static function getUsers()
    {
        try {
            $models = OdooAuth::getOdoo();

            // Buscar todos los usuarios
            $user_ids = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.users',
                'search',
                array(array())
            );

            // Leer los campos que necesitas de los usuarios
            $users = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.users',
                'read',
                array($user_ids, array('name', 'email')) // Añade o quita campos según tus necesidades
            );

            return $users;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getSalesTeams()
    {
        try {
            $models = OdooAuth::getOdoo();

            // Buscar los equipos de ventas
            $team_ids = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'crm.team',
                'search',
                array(array())
            );

            // Leer los campos que necesitas de los equipos de ventas
            $teams = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'crm.team',
                'read',
                array($team_ids, array('name')) // Añade o quita campos según tus necesidades
            );

            return $teams;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getAnalyticAccounts()
    {
        try {
            $models = OdooAuth::getOdoo();

            // Buscar las cuentas analíticas
            $account_ids = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'account.analytic.account',
                'search',
                array(array())
            );

            // Leer los campos que necesitas de las cuentas analíticas
            $accounts = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'account.analytic.account',
                'read',
                array($account_ids, array('name', 'code')) // Añade o quita campos según tus necesidades
            );

            return $accounts;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function verifyRFCAndCPClient($client_id, $rfc, $cp)
    {
        try {
            $models = OdooAuth::getOdoo();
            $clientDetails = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'read',
                array(array($client_id)),
                array('fields' => array('vat', 'zip'))
            );

            echo "<pre>";
            print_r($clientDetails);

            if ($clientDetails[0]['vat'] == $rfc && $clientDetails[0]['zip'] == $cp) {
                return true;
            }

            return false;
        } catch (Exception $e) {
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getClientIdByRFCOrEmail($rfc, $email)
    {
        try {
            $models = OdooAuth::getOdoo();
            $search_criteria = array();

            if (!empty($rfc)) {
                $search_criteria[] = array('vat', '=', $rfc);
            }

            if (!empty($email)) {
                if (!empty($search_criteria)) {
                    $search_criteria = array('|', $search_criteria[0], array('email', '=', $email));
                } else {
                    $search_criteria[] = array('email', '=', $email);
                }
            }

            if (empty($search_criteria)) {
                return false; // No search criteria provided
            }

            $client_ids = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'search',
                array($search_criteria)
            );

            if (count($client_ids) > 0) {
                $pricelists = $models->execute_kw(
                    OdooAuth::$db,
                    OdooAuth::$uid,
                    OdooAuth::$password,
                    'res.partner',
                    'read',
                    array(
                        $client_ids
                    ),
                    array('fields' => array('name', 'email', 'vat', 'zip', 'street', 'street2', 'city', 'company_name', 'state_id', 'country_id', 'mobile', 'regimen_fiscal_id', 'uso_cfdi_id'))
                );
                return $pricelists; // Return the first matching client ID
            } else {
                return false; // No matching client found
            }
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function updateClientFacturacion($client_id, $celular, $email, $calle, $calle2, $ciudad, $cp, $rfc, $nombre_empresa, $id_estado, $id_pais)
    {
        $cp_entero = intval($cp);
        $cp_formatted = str_pad($cp_entero, strlen($cp), "0", STR_PAD_LEFT);

        try {
            $models = OdooAuth::getOdoo();
            $result = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                // 'res.country.zip.sat.code',
                'write',
                array(
                    array($client_id),
                    array(
                        'company_name' => $nombre_empresa,
                        // 'state_id' => $id_estado,
                        'country_id' => $id_pais,
                        // 'street' => $calle,
                        // 'street2' => $calle2,
                        // 'city' => $ciudad,
                        'zip' => $cp_formatted,
                        // 'zip_sat_code' => $cp_formatted,
                        'vat' => $rfc,
                        'email' => $email,
                        // 'mobile' => $celular
                    )
                )
            );
            return $result;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function updateDatosFacturacion($client_id, $email, $cp, $rfc, $razon_social, $id_pais, $id_regimen_fiscal, $id_uso_cfdi)
    {

        $cp_entero = intval($cp);
        $cp_formatted = str_pad($cp_entero, strlen($cp), "0", STR_PAD_LEFT);

        try {
            $models = OdooAuth::getOdoo();
            $result = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'write',
                array(
                    array($client_id),
                    array(
                        'country_id' => $id_pais,
                        'zip' => $cp_formatted,
                        'vat' => $rfc,
                        'name' => $razon_social,
                        'company_name' => $razon_social,
                        'email' => $email,
                        'regimen_fiscal_id' => intval($id_regimen_fiscal),
                        'uso_cfdi_id' => intval($id_uso_cfdi)
                    )
                )
            );
            return $result;
        } catch (Exception $e) {
            error_log($e->getMessage());
            return false;
        }
    }

    public static function addClient($nombre, $apellido, $telefono, $email, $category_id)
    {
        try {
            $models = OdooAuth::getOdoo();
            $client_id = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'create',
                array(
                    array(
                        'name' => $nombre . " " . $apellido,
                        'mobile' => $telefono,
                        'email' => $email,
                        'category_id' => array(array(6, 0, array($category_id))) // 6 means replace the list with the provided ids
                    )
                )
            );
            return $client_id;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function updatePriceListCliente($client_id, $price_list_id)
    {
        try {
            $models = OdooAuth::getOdoo();
            $result = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'write',
                array(
                    array($client_id),
                    array(
                        'property_product_pricelist' => $price_list_id
                    )
                )
            );
            return $result;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function updateLanguageMXCliente($client_id)
    {
        try {
            $lang = 'es_MX';
            $models = OdooAuth::getOdoo();
            $result = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'write',
                array(
                    array($client_id),
                    array(
                        'lang' => $lang
                    )
                )
            );
            return $result;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getCategoryIdByName($category_name)
    {
        try {
            $models = OdooAuth::getOdoo();
            $category_ids = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner.category',
                'search',
                array(array(array('name', '=', $category_name)))
            );

            if (count($category_ids) > 0) {
                return $category_ids[0]; // Return the first matching category ID
            } else {
                return false; // No matching category found
            }
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getIdMexicoCountry()
    {
        try {
            $models = OdooAuth::getOdoo();
            $countries = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.country',
                'search',
                array(array(array('name', '=', 'Mexico')))
            );

            return $countries;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getStatesByCountry($country_id)
    {
        try {
            $models = OdooAuth::getOdoo();
            $state_ids = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.country.state',
                'search',
                array(array(array('country_id', '=', $country_id)))
            );

            $states = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.country.state',
                'read',
                array($state_ids),
                array('fields' => array('name'))
            );

            return $states;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getMunicipiosByEstado($id_estado)
    {
        try {

            $models = OdooAuth::getOdoo();

            $municipios = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.country.state', // Use the 'res.country.state' model
                'search_read',
                array(
                    array(
                        array('country_id', '=', $id_estado) // Filter by country
                    )
                ),
                array('fields' => array('name')) // Fields like the name of the state
            );

            return $municipios;
        } catch (Exception $e) {
            // Error handling
            error_log($e->getMessage());
            return false;
        }
    }
    // Este modelo es para agregar la dirección en la nueva sección de odoo en donde se espcifica que es para facturación
    public static function addInvoiceAddress($client_id, $email, $numero_celular, $rfc, $calle, $calle2, $ciudad, $cp, $nombre_empresa, $id_estado, $id_pais)
    {
        try {
            $models = OdooAuth::getOdoo();
            $result = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'create',
                array(
                    array(
                        'parent_id' => $client_id,
                        'type' => 'invoice',
                        'company_name' => $nombre_empresa,
                        'state_id' => $id_estado,
                        'country_id' => $id_pais,
                        'street' => $calle,
                        'street2' => $calle2,
                        'city' => $ciudad,
                        'zip' => $cp,
                        'vat' => 'MX' . $rfc,
                        'name' => $nombre_empresa,
                        'phone' => $numero_celular,
                        'email' => $email
                    )
                )
            );
            return $result;
        } catch (Exception $e) {
            error_log($e->getMessage());
            return false;
        }
    }
    // Este modelo es para actualizar la dirección en la nueva sección de odoo en donde se espcifica que es para facturación (Me prece que no se peude actualizar, será necesario eliminar las direcciones actuales y agregar la nueva o la que se deba actualziar)
    public static function updateInvoiceAddress($invoice_address_id, $email, $numero_celular, $calle, $calle2, $ciudad, $cp, $rfc, $nombre_empresa, $id_estado, $id_pais)
    {
        try {
            $models = OdooAuth::getOdoo();
            $result = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'write',
                array(
                    array(29),
                    array(
                        'company_name' => $nombre_empresa,
                        'state_id' => $id_estado,
                        'country_id' => $id_pais,
                        'street' => $calle,
                        'street2' => $calle2,
                        'city' => $ciudad,
                        'zip' => $cp,
                        'vat' => 'MX' . $rfc,
                        'name' => 'UPDATES',
                        'phone' => $numero_celular,
                        'email' => $email
                    )
                )
            );
            return $result;
        } catch (Exception $e) {
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getEdiUsage()
    {
        try {
            $models = OdooAuth::getOdoo();
            $ediUsage = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'sale.order',
                'fields_get',
                array(),
                array('context' => array(), 'attributes' => array('string', 'selection'))
            );

            $l10n_mx_edi_usage_selection = $ediUsage['l10n_mx_edi_usage']['selection'];

            return $l10n_mx_edi_usage_selection;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function validateRFC($client_id, $rfc)
    {
        try {
            $models = OdooAuth::getOdoo();
            $result = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'write',
                array(
                    array($client_id),
                    array(
                        'vat' => $rfc
                    )
                )
            );
            return $result;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getUsosCFDI()
    {
        try {
            $models = OdooAuth::getOdoo();
            $usosCFDI = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'sat.uso.cfdi',
                'search_read',
                array(array()), // No hay filtros, obtenemos todos los registros
                array('fields' => array('id', 'name'))
            );

            return $usosCFDI;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getPriceList($pricelist_name = 'Precio Público')
    {
        try {
            $models = OdooAuth::getOdoo();
            // Buscar todas las listas de precios
            $pricelist_ids = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.pricelist',
                'search',
                array(
                    array(
                        array('name', '=', $pricelist_name)
                    )
                )
            );

            // Leer los detalles de las listas de precios
            $pricelists = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.pricelist',
                'read',
                array(
                    $pricelist_ids
                ),
                array(
                    'fields' => array('id', 'name', 'currency_id', 'active')
                )
            );

            return $pricelists;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getCliente($client_id)
    {
        try {
            $models = OdooAuth::getOdoo();
            $client = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.partner',
                'read',
                array($client_id),
                array('fields' => array('name', 'email', 'vat', 'zip', 'street', 'street2', 'city', 'company_name', 'state_id', 'country_id', 'mobile', 'regimen_fiscal_id', 'uso_cfdi_id'))
            );

            return $client;
        } catch (Exception $e) {
            error_log($e->getMessage());
            return false;
        }
    }

    public static function checkUserPermissions($user_id)
    {
        try {
            $models = OdooAuth::getOdoo();
            $user_groups = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'res.users',
                'read',
                array($user_id),
                array('fields' => array('groups_id'))
            );
            return $user_groups;
        } catch (Exception $e) {
            error_log($e->getMessage());
            return false;
        }
    }
}
