<?php

require_once 'conexion.php';

class DireccionFacturacion
{
    public static function mdlGetDireccionFacturacionByIdFacturacion($id_direccion_facturacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM direccion_facturacion WHERE id_direccion_facturacion = :id_direccion_facturacion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_direccion_facturacion", $id_direccion_facturacion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDireccionFacturacionById($id_usuario, $id_direccion_facturacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM direccion_facturacion WHERE id_usuario = :id_usuario AND id_direccion_facturacion = :id_direccion_facturacion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_direccion_facturacion", $id_direccion_facturacion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDireccionesFacturacionById($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM direccion_facturacion WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddDireccionFacturacion($id_usuario, $razon_social, $rfc, $correo_facturacion, $id_regimen_fiscal, $nombre_regimen_fiscal, $cp, $estado, $delegacion, $colonia, $calle, $numero_exterior, $numero_interior, $numero_celular, $id_uso_cfdi, $nombre_uso_cfdi)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO direccion_facturacion (id_usuario, razon_social, rfc, correo_facturacion, id_regimen_fiscal, nombre_regimen_fiscal, cp, estado, delegacion, colonia, calle, numero_exterior, numero_interior, numero_celular, id_uso_cfdi, nombre_uso_cfdi) VALUES (:id_usuario, :razon_social, :rfc, :correo_facturacion, :id_regimen_fiscal, :nombre_regimen_fiscal, :cp, :estado, :delegacion, :colonia, :calle, :numero_exterior, :numero_interior, :numero_celular, :id_uso_cfdi, :nombre_uso_cfdi)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":razon_social", $razon_social);
        $stmt->bindParam(":rfc", $rfc);
        $stmt->bindParam(":correo_facturacion", $correo_facturacion);
        $stmt->bindParam(":id_regimen_fiscal", $id_regimen_fiscal);
        $stmt->bindParam(":nombre_regimen_fiscal", $nombre_regimen_fiscal);
        $stmt->bindParam(":cp", $cp);
        $stmt->bindParam(":estado", $estado);
        $stmt->bindParam(":delegacion", $delegacion);
        $stmt->bindParam(":colonia", $colonia);
        $stmt->bindParam(":calle", $calle);
        $stmt->bindParam(":numero_exterior", $numero_exterior);
        $stmt->bindParam(":numero_interior", $numero_interior);
        $stmt->bindParam(":numero_celular", $numero_celular);
        $stmt->bindParam(":id_uso_cfdi", $id_uso_cfdi);
        $stmt->bindParam(":nombre_uso_cfdi", $nombre_uso_cfdi);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateDireccionFacturacion($id_usuario, $id_direccion_facturacion, $razon_social, $rfc, $correo_facturacion, $id_regimen_fiscal, $nombre_regimen_fiscal, $cp, $estado, $delegacion, $colonia, $calle, $numero_exterior, $numero_interior, $numero_celular, $id_uso_cfdi, $nombre_uso_cfdi)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE direccion_facturacion SET razon_social = :razon_social, rfc = :rfc, correo_facturacion = :correo_facturacion, id_regimen_fiscal = :id_regimen_fiscal, nombre_regimen_fiscal = :nombre_regimen_fiscal, cp = :cp, estado = :estado, colonia = :colonia,  delegacion = :delegacion, calle = :calle, numero_exterior = :numero_exterior, numero_interior = :numero_interior, numero_celular = :numero_celular, id_uso_cfdi = :id_uso_cfdi, nombre_uso_cfdi = :nombre_uso_cfdi WHERE id_usuario = :id_usuario AND id_direccion_facturacion = :id_direccion_facturacion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":razon_social", $razon_social);
        $stmt->bindParam(":rfc", $rfc);
        $stmt->bindParam(":correo_facturacion", $correo_facturacion);
        $stmt->bindParam(":id_regimen_fiscal", $id_regimen_fiscal);
        $stmt->bindParam(":nombre_regimen_fiscal", $nombre_regimen_fiscal);
        $stmt->bindParam(":cp", $cp);
        $stmt->bindParam(":estado", $estado);
        $stmt->bindParam(":delegacion", $delegacion);
        $stmt->bindParam(":colonia", $colonia);
        $stmt->bindParam(":calle", $calle);
        $stmt->bindParam(":numero_exterior", $numero_exterior);
        $stmt->bindParam(":numero_interior", $numero_interior);
        $stmt->bindParam(":numero_celular", $numero_celular);
        $stmt->bindParam(":id_direccion_facturacion", $id_direccion_facturacion, PDO::PARAM_INT);
        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_uso_cfdi", $id_uso_cfdi);
        $stmt->bindParam(":nombre_uso_cfdi", $nombre_uso_cfdi);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteDireccionFacturacion($id_usuario, $id_direccion_facturacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM direccion_facturacion WHERE id_usuario = :id_usuario AND id_direccion_facturacion = :id_direccion_facturacion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_direccion_facturacion", $id_direccion_facturacion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlSetDireccionPredeterminada($id_usuario, $id_direccion_facturacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE direccion_facturacion SET direccion_predeterminada = CASE WHEN id_direccion_facturacion = :id_direccion_facturacion THEN 1 ELSE 0 END WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_direccion_facturacion", $id_direccion_facturacion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDireccionPredeterminada($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM direccion_facturacion WHERE id_usuario = :id_usuario AND direccion_predeterminada = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateEstadoDireccionFacturacion($id_usuario, $id_direccion_facturacion, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE direccion_facturacion SET activo = :activo WHERE id_usuario = :id_usuario AND id_direccion_facturacion = :id_direccion_facturacion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo, PDO::PARAM_BOOL);
        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_direccion_facturacion", $id_direccion_facturacion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetIdEstadoOdoo($estado)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT id_estado_odoo FROM estados_odoo WHERE nombre LIKE :nombre";

        $stmt = $db->prepare($sql);

        $estado = '%' . $estado . '%';
        $stmt->bindParam(":nombre", $estado);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC)['id_estado_odoo'] : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDireccionFacturacionByIdOrden($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT direccion_facturacion.* FROM orden left join direccion_facturacion on orden.id_direccion_facturacion = direccion_facturacion.id_direccion_facturacion WHERE orden.id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
