<?php

require_once 'conexion.php';

class Categoria
{
    public static function mdlGetAllCategorias()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM categoria ORDER BY id_categoria DESC";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $result = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        $db = null;
        return $result;
    }

    public static function mdlGetCategorias()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM categoria WHERE activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddCategoria($nombre, $descripcion, $url_pagina, $color)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO categoria (nombre, descripcion, url_pagina, color) VALUES (:nombre, :descripcion, :url_pagina, :color)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':url_pagina', $url_pagina);
        $stmt->bindParam(':color', $color);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateCategoriaImagen($id_categoria, $imagen)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE categoria SET imagen = :imagen WHERE id_categoria = :id_categoria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_categoria', $id_categoria);
        $stmt->bindParam(':imagen', $imagen);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateCategoria($id_categoria, $nombre, $descripcion, $url_pagina, $color)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE categoria SET nombre = :nombre, descripcion = :descripcion, url_pagina = :url_pagina, color = :color WHERE id_categoria = :id_categoria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_categoria', $id_categoria);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':url_pagina', $url_pagina);
        $stmt->bindParam(':color', $color);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetCategoriaById($id_categoria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM categoria WHERE id_categoria = :id_categoria AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_categoria', $id_categoria);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetCategoriaByNombre($nombre)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM categoria WHERE nombre = :nombre AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':nombre', $nombre);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateActivoCategoria($id_categoria, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE categoria SET activo = :activo WHERE id_categoria = :id_categoria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_categoria', $id_categoria);
        $stmt->bindParam(':activo', $activo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}
