<?php

require_once 'conexion.php';

class CardPublicitario
{

    public static function mdlUpdateCardPublicitarioImagen($id_card_publicitario, $url_imagen)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE card_publicitario SET url_imagen = :url_imagen WHERE id_card_publicitario = :id_card_publicitario";

        // $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        // $db->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_card_publicitario', $id_card_publicitario);
        $stmt->bindParam(':url_imagen', $url_imagen);

        $stmt->execute();

        return ($stmt->rowCount() > 0) ? true : false;
    }

    public static function mdlGetAllCardsPublicitarios()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM card_publicitario ORDER BY id_card_publicitario ASC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
 
    public static function mdlGetCardPublicitario($id_card_publicitario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM card_publicitario WHERE id_card_publicitario = :id_card_publicitario AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_card_publicitario', $id_card_publicitario);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddCardPublicitario($titulo, $descripcion, $url_imagen, $link, $color)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO card_publicitario (titulo, descripcion, url_imagen, link, color) VALUES (:titulo, :descripcion, :url_imagen, :link, :color)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':titulo', $titulo);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':url_imagen', $url_imagen);
        $stmt->bindParam(':link', $link);
        $stmt->bindParam(':color', $color);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateCardPublicitario($id_card_publicitario, $titulo, $descripcion, $link, $color, $texto_boton, $color_texto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE card_publicitario SET titulo = :titulo, descripcion = :descripcion, link = :link, color = :color, texto_boton = :texto_boton, color_texto = :color_texto WHERE id_card_publicitario = :id_card_publicitario";

        $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $db->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_card_publicitario', $id_card_publicitario);
        $stmt->bindParam(':titulo', $titulo);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':url_imagen', $url_imagen);
        $stmt->bindParam(':link', $link);
        $stmt->bindParam(':color', $color);
        $stmt->bindParam(':texto_boton', $texto_boton);
        $stmt->bindParam(':color_texto', $color_texto);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteCardPublicitario($id_card_publicitario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM card_publicitario WHERE id_card_publicitario = :id_card_publicitario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_card_publicitario', $id_card_publicitario);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateActivoCardPublicitario($id_card_publicitario, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE card_publicitario SET activo = :activo WHERE id_card_publicitario = :id_card_publicitario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_card_publicitario', $id_card_publicitario);
        $stmt->bindParam(':activo', $activo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }
}
