<?php

require_once 'conexion.php';

class CalificacionProducto
{

    // MODELOS PARA EL SISTEMA DE ADMINISTRACIÓN 

    public static function mdlSearchTotal($filtros, $terminoBusqueda)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "estado") {
                    $sqlFiltro .= "calificacion_producto.activo = " . $filtro['data']['activo'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(calificacion_producto.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(calificacion_producto.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND calificacion_producto.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "calificacion_producto.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "calificacion_producto.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "calificacion_producto.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "calificacion_producto.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? OR
                producto.nombre LIKE ? OR
                producto.sku LIKE ? OR
                calificacion_producto.comentario LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT COUNT(*) as total 
                FROM calificacion_producto left join usuario on calificacion_producto.id_usuario = usuario.id_usuario
                left join producto on calificacion_producto.id_producto = producto.id_producto 
                inner join producto_categoria on producto.id_producto = producto_categoria.id_producto
                inner join categoria on producto_categoria.id_categoria = categoria.id_categoria
                 " . $sqlTotal;
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
    }
    // ////////////////////////////////////////

    public static function mdlSearchLimit($filtros, $terminoBusqueda, $orden, $offset, $limit)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();
        $sqlOrden = '';

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "estado") {
                    $sqlFiltro .= "calificacion_producto.activo = " . $filtro['data']['activo'];
                }

                // if ($campo == "atendido") {
                //     if ($filtro['data']['atendido'] == "1")
                //         $sqlFiltro .= "respuesta.respuesta IS NOT NULL";
                //     else
                //         $sqlFiltro .= "respuesta.respuesta IS NULL";
                // }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(calificacion_producto.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(calificacion_producto.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND calificacion_producto.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "calificacion_producto.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "calificacion_producto.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "calificacion_producto.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "calificacion_producto.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? OR
                producto.nombre LIKE ? OR
                producto.sku LIKE ? OR
                calificacion_producto.comentario LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        if ($orden != NULL) {
            // AQUI VA EL QUERY PARA EL TERMINO DE LA ORDEN
            if ($orden['campo'] == 'nombre')
                $sqlOrden .= ' ORDER BY usuario.nombre ' . $orden['orden'];
            if ($orden['campo'] == 'fecha_alta')
                $sqlOrden .= ' ORDER BY calificacion_producto.fecha_alta ' . $orden['orden'];
        } else {
            $sqlOrden .= ' ORDER BY calificacion_producto.fecha_alta DESC';
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT calificacion_producto.*, usuario.nombre, usuario.apellido_paterno, usuario.apellido_materno, producto.nombre AS nombre_producto, producto.imagenes as imagenes_producto, categoria.color AS color_categoria
                FROM calificacion_producto left join usuario on calificacion_producto.id_usuario = usuario.id_usuario
                left join producto on calificacion_producto.id_producto = producto.id_producto 
                inner join producto_categoria on producto.id_producto = producto_categoria.id_producto
                inner join categoria on producto_categoria.id_categoria = categoria.id_categoria
                 " . $sqlTotal . " " . $sqlOrden . " LIMIT " . $offset . ", " . $limit;
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
    }
    // ////////////////////////////////////////


    public static function mdlGetCalificacionProductosResenas()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT usuario.id_usuario, usuario.nombre, usuario.apellido_paterno, usuario.foto_perfil, calificacion_producto.id_calificacion_producto, calificacion_producto.calificacion, calificacion_producto.comentario, calificacion_producto.imagen_resena FROM usuario INNER JOIN calificacion_producto ON usuario.id_usuario = calificacion_producto.id_usuario WHERE calificacion_producto.activo = 1 ORDER BY RAND() LIMIT 10";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddCalificacionProducto($id_usuario, $id_producto, $calificacion, $comentario, $imagen_resena)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO calificacion_producto (id_usuario, id_producto, calificacion, comentario, imagen_resena, activo) VALUES (:id_usuario, :id_producto, :calificacion, :comentario, :imagen_resena, 1)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);
        $stmt->bindParam(':calificacion', $calificacion, PDO::PARAM_INT);
        $stmt->bindParam(':comentario', $comentario, PDO::PARAM_STR);
        $stmt->bindParam(':imagen_resena', $imagen_resena, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateCalificacionProducto($id_calificacion_producto, $calificacion, $comentario, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE calificacion_producto SET calificacion = :calificacion, comentario = :comentario, activo = :activo WHERE id_calificacion_producto = :id_calificacion_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_calificacion_producto', $id_calificacion_producto, PDO::PARAM_INT);
        $stmt->bindParam(':calificacion', $calificacion, PDO::PARAM_INT);
        $stmt->bindParam(':comentario', $comentario, PDO::PARAM_STR);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteCalificacionProducto($id_calificacion_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM calificacion_producto WHERE id_calificacion_producto = :id_calificacion_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_calificacion_producto', $id_calificacion_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDetallesCalificacionProducto($id_calificacion_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM calificacion_producto WHERE id_calificacion_producto = :id_calificacion_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_calificacion_producto', $id_calificacion_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDetallesCalificacionProductoByIdUsuario($id_usuario, $id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM calificacion_producto WHERE id_usuario = :id_usuario AND id_producto = :id_producto AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateCalificacionProductoImagen($id_calificacion_producto, $imagen_resena)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE calificacion_producto SET imagen_resena = :imagen_resena WHERE id_calificacion_producto = :id_calificacion_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_calificacion_producto', $id_calificacion_producto, PDO::PARAM_INT);
        $stmt->bindParam(':imagen_resena', $imagen_resena, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateActivoCalificacionProducto($id_calificacion_producto, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE calificacion_producto SET activo = :activo WHERE id_calificacion_producto = :id_calificacion_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':activo', $activo, PDO::PARAM_INT);
        $stmt->bindParam(':id_calificacion_producto', $id_calificacion_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetCalificacionProductosResenasByIdProducto($id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT usuario.id_usuario, usuario.nombre, usuario.apellido_paterno, usuario.foto_perfil, usuario.uid_google, usuario.uid_facebook, calificacion_producto.id_calificacion_producto, calificacion_producto.calificacion, calificacion_producto.comentario, calificacion_producto.imagen_resena 
                FROM usuario INNER JOIN calificacion_producto ON usuario.id_usuario = calificacion_producto.id_usuario 
                WHERE calificacion_producto.activo = 1 ORDER BY RAND() LIMIT 10";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetCalificacionesByIdUsuario($id_usuario, $limit)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT calificacion_producto.id_calificacion_producto, calificacion_producto.id_producto, calificacion_producto.calificacion, calificacion_producto.comentario, calificacion_producto.imagen_resena, calificacion_producto.fecha_alta, producto.nombre as nombre_producto, producto.imagenes, categoria.color AS color_categoria, calificacion_producto.activo
        
        FROM calificacion_producto 
            INNER JOIN producto ON calificacion_producto.id_producto = producto.id_producto 
            INNER JOIN producto_categoria on producto.id_producto = producto_categoria.id_producto
            INNER JOIN categoria on producto_categoria.id_categoria = categoria.id_categoria
        
        WHERE calificacion_producto.id_usuario = :id_usuario ORDER BY calificacion_producto.fecha_alta DESC LIMIT :limit";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
