<?php

require_once 'conexion.php';

class AlmacenesOdoo
{   
    // Al ser una función que trae los almacenes para calcular el stock total disponible para comprar
    // evitamos usar el almacén de E-COMMERCE
    public static function mdlGetIdAlmacenesOdoo()
    {
        $conexion = new Conexion();

        $db = $conexion->get_connection();

        // Evitamos traer el nombre_almacen = "E-COMMERCE"
        $sql = "SELECT id_odoo, nombre_almacen, codigo_almacen FROM almacenes_odoo WHERE nombre_almacen != 'E-COMMERCE'";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetAlmacenOdooById($id_almacen_odoo)
    {
        $conexion = new Conexion();

        $db = $conexion->get_connection();

        $sql = "SELECT * FROM almacenes_odoo WHERE id_odoo = :id_almacen_odoo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_almacen_odoo", $id_almacen_odoo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
    public static function mdlGetIdLotStock($id_almacen)
    {
        $conexion = new Conexion();

        $db = $conexion->get_connection();

        $sql = "SELECT id_lot_stock, id_tipo_picking FROM almacenes_odoo WHERE id_odoo = :id_almacen";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_almacen", $id_almacen);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
