<?php

require_once 'conexion.php';

class AdHeader
{
    public static function mdlGetAdHeaders()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM ad_header WHERE activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
    
    public static function mdlGetAdHeaderById($id_ad_header)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM ad_header WHERE id_ad_header = :id_ad_header";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_ad_header", $id_ad_header);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddAdHeader($titulo, $url, $color)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO ad_header (titulo, url, color) VALUES (:titulo, :url, :color)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":titulo", $titulo);
        $stmt->bindParam(":url", $url);
        $stmt->bindParam(":color", $color);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateAdHeader($id_ad_header, $titulo, $url, $color, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE ad_header SET titulo = :titulo, url = :url, color = :color, activo = :activo WHERE id_ad_header = :id_ad_header";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":titulo", $titulo);
        $stmt->bindParam(":url", $url);
        $stmt->bindParam(":color", $color);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":id_ad_header", $id_ad_header, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteAdHeader($id_ad_header)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM ad_header WHERE id_ad_header = :id_ad_header";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_ad_header", $id_ad_header);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateEstadoAdHeader($id_ad_header, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE ad_header SET activo = :activo WHERE id_ad_header = :id_ad_header";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':activo', $activo, PDO::PARAM_INT);
        $stmt->bindParam(':id_ad_header', $id_ad_header, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }
}
