<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['apellido_paterno']) ||
    !isset($_POST['apellido_materno']) ||
    !isset($_POST['correo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$nombre = $_POST['nombre'];
$apellido_paterno = $_POST['apellido_paterno'];
$apellido_materno = $_POST['apellido_materno'];
$correo = $_POST['correo'];
$celular = (isset($_POST['celular'])) ? $_POST['celular'] : null;
$fecha_nacimiento = (isset($_POST['fecha_nacimiento'])) ? $_POST['fecha_nacimiento'] : null;
$id_sexo = (isset($_POST['id_sexo'])) ? $_POST['id_sexo'] : null;

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('usuario', $id_usuario));

$usuario = Usuario::mdlUpdateUsuarioGeneral(
    $id_usuario,
    $nombre,
    $apellido_paterno,
    $apellido_materno,
    $correo,
    $celular,
    $fecha_nacimiento,
    $id_sexo
);

if (!$usuario) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizo el usuario';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'usuario', $id_usuario, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $usuario;

echo json_encode($response);
