<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../../modelo/permiso_usuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
require './decodeUsuario.php';

if (
    !isset($_POST['id']) ||
    !isset($_POST['id_usuario']) ||
    !isset($_POST['is_edit_permisos']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['apellido_paterno']) ||
    !isset($_POST['apellido_materno']) ||
    !isset($_POST['correo']) ||
    !isset($_POST['permisos_sistema'])
) {
    echo json_encode([
        'response' => 'error',
        'message' => 'POST error',
    ]);
    return;
}

$id = DecodeUser::handlePostUsuario($_POST['id']);
if (!$id) {
    echo json_encode([
        'response' => 'error',
        'message' => 'Id del usuario activo incorrecto.'
    ]);
    return;
}

$id_usuario_activo = $id;
$id_usuario = $_POST['id_usuario'];
$nombre = $_POST['nombre'];
$apellido_paterno = $_POST['apellido_paterno'];
$apellido_materno = $_POST['apellido_materno'];
$correo = $_POST['correo'];
$is_edit_permisos = $_POST['is_edit_permisos'] == 1 ? true : false;
$permisos_sistema = json_decode($_POST['permisos_sistema'], true);

// 1. Validamos si el usuario ya existe, y si existe retornamos un error
$validar_usuario_existente = Usuario::mdlExisteUsuarioByCorreo($correo);
if ($validar_usuario_existente) {
    // Verificar si el usuario que ya existe es el mismo que se está editando
    if ($validar_usuario_existente['id_usuario'] != $id_usuario) {
        echo json_encode([
            'response' => 'error',
            'message' => 'El usuario ya existe.',
            'data' => 'exists'
        ]);
        return;
    }
}

// 2. Actualizamos la información básica del usuario
$valor_anterior = json_encode(ModeloGlobal::mdlSelect('usuario', $id_usuario));
$update = Usuario::mdlUpdateUsuarioGeneral($id_usuario, $nombre, $apellido_paterno, $apellido_materno, $correo, NULL, NULL, NULL);

// 3. Agregamos los cambios de update de usuario en el historial
if($update){
    ModeloHistory::mdlAddNewRegister('update', 'usuario', $id_usuario, $id_usuario_activo, $valor_anterior);
}

// 4. Actualizamos los permisos del usuario a la base de datos, en caso de que así lo hayan solicitado
$updatePermisos = false;
if ($is_edit_permisos) {

    // 4.1. De cada uno de los permisos actuales daremos de alta en el historial el cambio
    $permisos_actuales = PermisoUsuario::mdlGetPermisoByUsuario($id_usuario);

    if ($permisos_actuales) {
        foreach ($permisos_actuales as $key => $value) {
            $valor_anterior = json_encode($value);
            ModeloHistory::mdlAddNewRegister('update', 'permiso_usuario', $value['id_permiso_usuario'], $id_usuario_activo, $valor_anterior);
        }
    }

    if ($permisos_sistema) {
        // 4.2. Desactivamos los permisos actuales del usuario
        PermisoUsuario::mdlDesactivarPermisosUsuario($id_usuario);
        // 4.3. Agregamos los nuevos permisos del usuario
        foreach ($permisos_sistema as $key => $value) {
            $_value = explode("_", $value);
            $id_modulo_permiso = $_value[0];
            $tipo_permiso = $_value[1];
            if (!PermisoUsuario::mdlExistPermisoUsuario($id_usuario, $id_modulo_permiso)) {
                $id_permiso_usuario = PermisoUsuario::mdlAddPermisoUsuario($id_usuario, $id_modulo_permiso);
                if ($id_permiso_usuario) {
                    ModeloHistory::mdlAddNewRegister('create', 'permiso_usuario', $id_permiso_usuario, $id_usuario_activo, NULL);
                }
            }

            if (!PermisoUsuario::mdlUpdatePermisoUsuario($id_usuario, $id_modulo_permiso, $tipo_permiso, 1)) {
                $data = array();
                $data["response"] = "error";
                $data["message"] = "Error al actualizar el permiso";
                echo json_encode($data);
                return false;
            }
        }

        $updatePermisos = true;
    }
}

// 5. Retornamos si el usuario ha sido actualizado correctamente
if (!$update && !$updatePermisos) {
    echo json_encode([
        'response' => 'success',
        'message' => 'No se actualizó nada del usuario.'
    ]);
    return;
}

if (!$update && $updatePermisos) {
    echo json_encode([
        'response' => 'success',
        'message' => 'Información de los permisos actualizada correctamente.',
    ]);
    return;
}

if ($update && !$updatePermisos) {
    echo json_encode([
        'response' => 'success',
        'message' => 'Información del usuario actualizada correctamente.',
    ]);
    return;
}

echo json_encode([
    'response' => 'success',
    'message' => 'Información del usuario y permisos actualizada correctamente.',
]);
