<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../../modelo/environment.php';

$response = array();

if(!isset($_POST['id_usuario'])){
    $response['response'] = 'error';
    $response['message'] = 'No se recibió el id del usuario';
    echo json_encode($response);
    return;
}

$id_usuario = $_POST['id_usuario'];

$usuario = Usuario::mdlGetUsuarioById($id_usuario);

if (!$usuario) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontró el usuario';
    echo json_encode($response);
    return;
}

// Formateo la fecha de creación
$fecha = date($usuario['fecha_alta']);
$fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
$usuario['fecha_alta'] = $fechaFormat;

// Le agregamos nuestra URL al campo de la imagen, y no colocara si la url comienza con https (porque algunas fotos de perfil las obtienen de google)
if(!is_null($usuario['foto_perfil']) && !preg_match('/^https/', $usuario['foto_perfil'])){
    $usuario['foto_perfil'] = Environment::getUrlServidor() . $usuario['foto_perfil'];
}

$response['response'] = 'success';
$response['data'] = $usuario;

echo json_encode($response);
