<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../../modelo/permiso_usuario.php';
require '../../modelo/history.php';
require './decodeUsuario.php';


if (
    !isset($_POST['id']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['apellido_paterno']) ||
    !isset($_POST['apellido_materno']) ||
    !isset($_POST['correo']) ||
    !isset($_POST['password']) ||
    !isset($_POST['permisos_sistema'])
) {
    echo json_encode([
        'response' => 'error',
        'message' => 'POST error',
    ]);
    return;
}

$id = DecodeUser::handlePostUsuario($_POST['id']);
if (!$id) {
    echo json_encode([
        'response' => 'error',
        'message' => 'Id del usuario activo incorrecto.'
    ]);
    return;
}

$id_usuario_activo = $id;
$nombre = $_POST['nombre'];
$apellido_paterno = $_POST['apellido_paterno'];
$apellido_materno = $_POST['apellido_materno'];
$correo = $_POST['correo'];
$password = password_hash($_POST['password'], PASSWORD_DEFAULT);
$permisos_sistema = json_decode($_POST['permisos_sistema'], true);
// $ip = $_SERVER['REMOTE_ADDR'];
$ip = "192.168.1.1";
// $details = json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip={$ip}"));
// $pais = $details->geoplugin_countryCode;
$pais = "MX";
// $user_agent = $_SERVER['HTTP_USER_AGENT'];
$user_agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36";

// 1. Validamos si el usuario ya existe, y si existe retornamos un error
$validar_usuario_existente = Usuario::mdlVerifyUsuarioExistente($correo, NULL);
if ($validar_usuario_existente) {
    echo json_encode([
        'response' => 'error',
        'message' => 'El usuario ya existe.',
        'data' => 'exists'
    ]);
    return;
}

// 2. Agregamos el usuario a la base de datos
$id_usuario = Usuario::mdlAddUsuarioAdministracion($nombre, $apellido_paterno, $apellido_materno, $correo, $password, $pais, $user_agent, $ip);
if(!$id_usuario) {
    echo json_encode([
        'response' => 'error',
        'message' => 'Error al agregar el usuario.'
    ]);
    return;
}

// 3. Agregamos los cambios de alta de usuario en el historial
ModeloHistory::mdlAddNewRegister('create', 'usuario', $id_usuario, $id_usuario_activo, NULL);

// 4. Agregamos los permisos del usuario a la base de datos
foreach($permisos_sistema as $key => $value){
    $_value = explode("_", $value); // Ej: 1_leer, 2_leer, 2_escribir
    $id_modulo_permiso = $_value[0]; // Ej: cada id es un permiso diferente en la bd
    $tipo_permiso = $_value[1]; // Ej: leer, escribir, eliminar, editar

    if( !PermisoUsuario::mdlExistPermisoUsuario($id_usuario, $id_modulo_permiso) ){
        $id_permiso_usuario = PermisoUsuario::mdlAddPermisoUsuario($id_usuario, $id_modulo_permiso);
        if($id_permiso_usuario){
            ModeloHistory::mdlAddNewRegister('create', 'permiso_usuario', $id_permiso_usuario, $id_usuario_activo, NULL);
        }
    }

    if(!PermisoUsuario::mdlUpdatePermisoUsuario($id_usuario, $id_modulo_permiso, $tipo_permiso, 1)){
        $data = array();
        $data["response"] = "error";
        $data["message"] = "Error al actualizar el permiso";
        echo json_encode($data);
        return false;
    }
}

// 5. Retornamos el id del usuario agregado
echo json_encode([
    'response' => 'success',
    'message' => 'Se agregó correctamente',
    'data' => $id_usuario,
    'id_usuario' => $id_usuario
]);
