<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/tipo_soporte_tecnico.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];

$tipo_soporte_tecnico = TipoSoporteTecnico::mdlAddTipoSoporteTecnico($nombre, $descripcion);

if (!$tipo_soporte_tecnico) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó el tipo de soporte técnico';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'tipo_soporte_tecnico', $tipo_soporte_tecnico, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $tipo_soporte_tecnico;

echo json_encode($response);