<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/subcategoria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (isset(
    $_POST['id_usuario'],
    $_POST['id_subcategoria']
)) {
    if (isset($_FILES['imagen']['name'])) {

        $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

        if (!$id_usuario) {

            $response['response'] = 'error';
            $response['data'] = 'Id del usuario incorrecto.';

            echo json_encode($response);
            return;
        }

        $id_subcategoria = $_POST['id_subcategoria'];

        $imagen = $_FILES['imagen']['name'];

        $extension = pathinfo($imagen, PATHINFO_EXTENSION);
        $nombreImagen = uniqid() . "-" . $id_subcategoria . '.' . $extension;

        $imagenRuta = '../../assets/images/subcategoria/' . $nombreImagen;

        $valor_anterior = json_encode(ModeloGlobal::mdlSelect('subcategoria', $id_subcategoria));

        if (move_uploaded_file($_FILES['imagen']['tmp_name'], $imagenRuta)) {
            $rutaFinal = "assets/images/subcategoria/" . $nombreImagen;
            if (Subcategoria::mdlUpdateSubcategoriaImagen($id_subcategoria, $rutaFinal)) {
                ModeloHistory::mdlAddNewRegister('update', 'subcategoria', $id_subcategoria, $id_usuario, $valor_anterior);

                $response['response'] = 'success';
                $response['data'] = true;
                echo json_encode($response);
                return;
            }
        } else {
            $response['response'] = 'error';
            $response['data'] = 'No se pudo subir la imagen';
        }
    } else {
        $response['response'] = 'error';
        $response['data'] = 'No hay imagen';
    }
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
}

echo json_encode($response);
