<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require_once '../../modelo/zona_extendida.php';
require_once '../../modelo/zonas_extendidas_express.php';
require_once '../../modelo/zonas_extendidas_dhl.php';

// $csvFilePath = '../../vista/assets/sepomex/zonas-extendidas.csv';
// $csvFilePath = '../../vista/assets/sepomex/zonas_extendidas_express.csv';
$csvFilePath = '../../vista/assets/sepomex/zonas_extendidas_dhl.csv';

$handle = fopen($csvFilePath, 'r');
if ($handle === false) {
    throw new Exception("Could not open file: $csvFilePath");
}

$successCount = 0;
$totalCount = 0;

while (($data = fgetcsv($handle, 1000, ",")) !== false) {
    $totalCount++;
    list($cp) = $data;

    $result = ZonaExtendidaDHL::mdlAddZonaExtendidaDHL($cp);

    if ($result) {
        echo "Row inserted successfully: $cp\n";
        $successCount++;
    } else {
        echo "Failed to insert row: $cp\n";
    }
}

fclose($handle);

echo "Total rows inserted: $successCount\n";
echo "Total rows processed: $totalCount\n";

if ($successCount === $totalCount) {
    echo "All rows were inserted successfully.\n";
} else {
    echo "Some rows were not inserted successfully.\n";
}
?>