<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/proveedor.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_proveedor'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_proveedor = $_POST['id_proveedor'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('proveedor', $id_proveedor));

$proveedor = Proveedor::mdlDeleteProveedor($id_proveedor);

if (!$proveedor) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo eliminar el proveedor.';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'proveedor', $id_proveedor, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);