<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../../modelo/odoo_producto.php';
require '../../modelo/precio.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_producto']) ||
    !isset($_POST['id_producto_odoo'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

// 1. Vamos a obtener los datos de peso, alto, ancho, largo y precio de Odoo
// usando el id_producto_odoo
$id_producto_odoo = $_POST['id_producto_odoo'];
$id_producto = $_POST['id_producto'];

$datos_producto_odoo = OdooProducto::searchProduct($id_producto_odoo);

$precio = $datos_producto_odoo[0]['list_price'];
$peso = $datos_producto_odoo[0]['weight'];
$alto = $datos_producto_odoo[0]['product_height'];
$ancho = $datos_producto_odoo[0]['product_width'];
$largo = $datos_producto_odoo[0]['product_length'];
$precio_con_iva = $precio * 1.16;
$has_cambios = false;

// 2. Verificamos si el precio es el mismo que el precio actual, si no lo es, actualizamos el precio
$data_producto = Producto::mdlGetProductoById($id_producto);
$precio_actual_sin_iva = $data_producto['precio_iva'];

$producto = array(
    'precio' => $precio,
    'peso' => $peso,
    'alto' => $alto,
    'ancho' => $ancho,
    'largo' => $largo,
    'precio_iva' => $precio * 1.16,
    'precio_actual_sin_iva' => $precio_actual_sin_iva
);

if ($precio_actual_sin_iva != strval($precio)) {
    $etiqueta_precio = NULL; // <--- Se usa solo cuando se agregan los cupones
    $id_precio = Precio::mdlAddPrecio($precio_con_iva, $precio, $etiqueta_precio, $id_producto);

    if (!$id_precio) {
        $response['response'] = 'error';
        $response['message'] = 'Error al agregar el precio del producto en la base de datos';
        echo json_encode($response);
        return;
    }

    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('producto', $id_producto));

    // 2.1 Vinculamos el nuevo precio al producto
    Producto::mdlUpdatePrecio($id_producto, $id_precio);

    // 2.2 Agregamos el registro en la tabla history
    ModeloHistory::mdlAddNewRegister('create', 'precio', $id_precio, $id_usuario, NULL);
    ModeloHistory::mdlAddNewRegister('update', 'producto', $id_producto, $id_usuario, $valor_anterior);

    $has_cambios = true;
}

// 3. Actualizamos los datos de peso, alto, ancho y largo del producto
$valor_anterior = json_encode(ModeloGlobal::mdlSelect('producto', $id_producto));
$update = Producto::updateDatosOdooById($id_producto, $peso, $alto, $ancho, $largo);

if (!$update && !$has_cambios) {
    $response['response'] = 'info';
    $response['message'] = 'Los datos siguen siendo son los mismos';
    echo json_encode($response);
    return;
}

if ($update) {
    ModeloHistory::mdlAddNewRegister('update', 'producto', $id_producto, $id_usuario, $valor_anterior);
}

$response['response'] = 'success';
$response['message'] = 'Producto actualizado correctamente';
echo json_encode($response);
