<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

require '../../modelo/environment.php';
require '../../modelo/global.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/producto.php';
require '../../modelo/producto_categoria.php';
require '../../modelo/precio.php';
require '../../modelo/history.php';

$response = array();

// alto
// ancho
// descripcion_corta
// id_categoria
// id_content_dynamic_fb
// id_producto
// id_proveedor
// id_subcategoria
// is_soporte_tecnico
// largo
// meta_description
// meta_title
// nombre
// peso
// precio
// tiempo_garantia
// url_pagina
// url_video

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['descripcion_corta']) ||
    !isset($_POST['id_categoria']) ||
    !isset($_POST['id_content_dynamic_fb']) ||
    !isset($_POST['id_producto']) ||
    !isset($_POST['id_proveedor']) ||
    !isset($_POST['id_subcategoria']) ||
    !isset($_POST['is_soporte_tecnico']) ||
    !isset($_POST['meta_description']) ||
    !isset($_POST['meta_title']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['tiempo_garantia']) ||
    !isset($_POST['url_pagina']) ||
    !isset($_POST['url_video'])

) {
    $response['response'] = 'error';
    $response['message'] = 'No se recibieron los campos necesarios';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_producto = $_POST['id_producto'];
$nombre = $_POST['nombre'];
$descripcion_corta = ($_POST['descripcion_corta'] == '') ? NULL : $_POST['descripcion_corta'];
$id_proveedor = $_POST['id_proveedor'];
$url_video = ($_POST['url_video'] == '') ? NULL : $_POST['url_video'];
$is_soporte_tecnico = $_POST['is_soporte_tecnico'];
$url_pagina = $_POST['url_pagina'];
$meta_title = ($_POST['meta_title'] == '') ? NULL : $_POST['meta_title'];
$meta_description = ($_POST['meta_description'] == '') ? NULL : $_POST['meta_description'];
$id_content_dynamic_fb = ($_POST['id_content_dynamic_fb'] == '') ? NULL : $_POST['id_content_dynamic_fb'];
$tiempo_garantia = $_POST['tiempo_garantia'];

$id_categoria = $_POST['id_categoria'];
$id_subcategoria = $_POST['id_subcategoria'];


$is_modificado = false;

// 1. Verificamos si el id de la categoria y subcategoria es el mismo que el que ya tenemos
$categoria = ProductoCategoria::mdlGetCategoriaAndSubcategoriaById($id_producto);

if ($categoria['id_categoria'] != $id_categoria || $categoria['id_subcategoria'] != $id_subcategoria) {
    // Si no es el mismo, borramos el actual que tenemos y subimos el nuevo
    $id_producto_categoria = $categoria['id_producto_categoria'];

    // Borramos el actual
    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('producto_categoria', $id_producto_categoria));
    ProductoCategoria::mdlDeleteCategoriaById($id_producto_categoria);
    ModeloHistory::mdlAddNewRegister('delete', 'producto_categoria', $id_producto_categoria, $id_usuario, $valor_anterior);

    // Damos de alta el nuevo
    $new = ProductoCategoria::mdlAddCategoriaAndSubcategoriaByProducto($id_producto, $id_categoria, $id_subcategoria);
    ModeloHistory::mdlAddNewRegister('create', 'producto_categoria', $new, $id_usuario, NULL);

    $is_modificado = true;
}

// 2. Actualizamos el producto
$valor_anterior_producto = json_encode(ModeloGlobal::mdlSelect('producto', $id_producto));
$updated = Producto::mdlUpdateById(
    $id_producto,
    $nombre,
    $descripcion_corta,
    $id_proveedor,
    $url_video,
    $is_soporte_tecnico,
    $url_pagina,
    $meta_title,
    $meta_description,
    $id_content_dynamic_fb,
    $tiempo_garantia
);


if ($updated) {
    ModeloHistory::mdlAddNewRegister('update', 'producto', $id_producto, $id_usuario, $valor_anterior_producto);
    $is_modificado = true;
}

if (!$is_modificado) {
    $response['response'] = 'error';
    $response['message'] = 'No hay cambios por aplicar';
    echo json_encode($response);
    return;
}

$response['response'] = 'success';
$response['message'] = 'Producto actualizado correctamente';
echo json_encode($response);