<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_producto']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_producto = $_POST['id_producto'];
$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('producto', $id_producto));

// No actualizar si el producto no tiene imagenes ni URL.
if ($activo == 1) {
    $producto = Producto::mdlGetProductoById($id_producto);
    if (is_null($producto['imagenes']) || $producto['url_pagina'] == '') {
        $response['response'] = 'error';
        $response['message'] = 'No se puede activar un producto sin imagenes ni URL.';
        echo json_encode($response);
        return;
    }
}

$producto = Producto::mdlUpdateEstadoProducto($id_producto, $activo);

if (!$producto) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar el campo activo.';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'producto', $producto, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = $producto;

echo json_encode($response);
return;
