<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

// VALIDAR SI LOS CAMPOS EXISTEN
if (!isset(
    $_POST['id_usuario'],
    $_POST['id_producto']
)) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

// VALIDAR SI EXISTE LA IMAGEN
if (!isset($_FILES['imagen']['name'])) {
    $response['response'] = 'error';
    $response['message'] = 'No hay imagen';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

// VALIDAR SI EL USUARIO EXISTE
if (!$id_usuario) {

    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$id_producto = $_POST['id_producto'];

$imagen = $_FILES['imagen']['name'];

$extension = pathinfo($imagen, PATHINFO_EXTENSION);
$nombreImagen = uniqid() . "-" . $id_producto . '.' . $extension;

$imagenRuta = '../../assets/images/producto/' . $nombreImagen;

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('producto', $id_producto));

if (!move_uploaded_file($_FILES['imagen']['tmp_name'], $imagenRuta)) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo subir la imagen';
    echo json_encode($response);
    return;
}

$rutaFinal = "assets/images/producto/" . $nombreImagen;

// Obtenemos el arreglo de las imágenes actuales, y le agregamos la nueva, con la propiedad url, id y orden
$producto = Producto::mdlGetProductoById($id_producto);
$imagenes = json_decode($producto['imagenes']);
$imagen_data = array(
    'url' => $rutaFinal,
    'id' => uniqid(),
    'orden' => count($imagenes)+1
);
$imagenes[] = $imagen_data;
$imagenes = json_encode($imagenes);

// Actualizamos la imagen

if (!Producto::mdlUpdateProductoImagen($id_producto, $imagenes)) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo agregar la imagen';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'producto', $id_producto, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = true;
echo json_encode($response);
