<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/pregunta.php';
require '../../modelo/environment.php';
// require '../pregunta/decodePregunta.php';

const LIMITE_DE_CLIENTES_POR_PAGINA = 20;

$numero_pagina = ($_POST['numero_pagina'] - 1);
$offset = $numero_pagina * LIMITE_DE_CLIENTES_POR_PAGINA;

$termino_busqueda = $_POST['termino_busqueda'];
$orderBy = json_decode($_POST['orderBy'], true);
$filters = json_decode($_POST['filters'], true);

$preguntas = Pregunta::mdlSearchLimit($filters, $termino_busqueda, $orderBy, $offset, LIMITE_DE_CLIENTES_POR_PAGINA);
$total_preguntas = Pregunta::mdlSearchTotal($filters, $termino_busqueda);

if (!$preguntas) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron preguntas';
    echo json_encode($response);
    return;
}

foreach ($preguntas as $key => $pregunta) {
    $respuesta = $pregunta['respuesta'];
    $preguntas[$key]['atendido'] = !is_null($respuesta) ? '1' : '0';

    $preguntas[$key]['nombre_completo'] = $pregunta['nombre'] . ' ' . $pregunta['apellido_paterno'] . ' ' . $pregunta['apellido_materno'];
    $fecha = date($pregunta['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
    $preguntas[$key]['fecha_alta'] = $fechaFormat;

    if(!is_null($pregunta['imagenes_producto'])){
        $imagenes = json_decode($pregunta['imagenes_producto']);
        $imagenes_url = array();
        $url_servidor = Environment::getUrlServidor();
    
        $preguntas[$key]['url_imagen'] = $url_servidor . $imagenes[0]->url;
    }

    $preguntas[$key]['color_fondo'] = $pregunta['color_categoria'];
    
}

$response['response'] = 'success';
$response['data'] = array(
    "preguntas" => $preguntas,
    "total_preguntas" => $total_preguntas['total'],
    "limite" => LIMITE_DE_CLIENTES_POR_PAGINA,
);

echo json_encode($response);