<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/paqueteria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['activo']) ||
    !isset($_POST['id_paqueteria'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$activo = $_POST['activo'];
$id_paqueteria = $_POST['id_paqueteria'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('paqueteria', $id_paqueteria));

$paqueteria = Paqueteria::mdlUpdateEstadoPaqueteria($id_paqueteria, $activo);

if (!$paqueteria) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar el estado de la paqueteria';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'paqueteria', $id_paqueteria, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $paqueteria;

echo json_encode($response);