<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/paqueteria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_paqueteria']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_paqueteria = $_POST['id_paqueteria'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('paqueteria', $id_paqueteria));

$paqueteria = Paqueteria::mdlDeletePaqueteria($id_paqueteria);

if (!$paqueteria) {
    $response['response'] = 'error';
    $response['data'] = 'No se eliminó la paqueteria';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'paqueteria', $id_paqueteria, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $paqueteria;

echo json_encode($response);