<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/paqueteria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];

$paqueteria = Paqueteria::mdlAddPaqueteria($nombre, $descripcion);

if (!$paqueteria) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó la paqueteria';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'paqueteria', $paqueteria, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $paqueteria;

echo json_encode($response);