<?php

require_once '../../modelo/pak2go.php';
require_once '../../modelo/peso_envio.php';
require_once '../../modelo/producto.php';

class GenerarGuiaPak2Go
{
    public static function cotizarGuia($almacen, $nombre_paquetria_seleccionada, $direccion_envio, $direccion_facturacion, $correo_usuario)
    {
        $peso = $almacen['peso_total'];

        $id_almacen_odoo = $almacen['almacen'];

        $caja_envio = ModeloPesoEnvio::mdlGetCostosEnvio($peso);

        $cotenido_paquete = "";

        foreach ($almacen['productos'] as $key => $value) {
            $nombre_producto = Producto::mdlGetProductoById($value['id_producto']);

            if ($key == count($almacen['productos']) - 1) {
                $cotenido_paquete = $nombre_producto['nombre'];
            } else {
                $cotenido_paquete = $nombre_producto['nombre'] . ", ";
            }
        }

        $direccion_almacen = AlmacenesOdoo::mdlGetAlmacenOdooById($id_almacen_odoo);

        $data = [
            "address_from" => [
                "province" => $direccion_almacen['estado'],
                "city" => $direccion_almacen['delegacion'],
                "name" => $direccion_almacen['encargado_almacen'],
                "zip" => $direccion_almacen['cp'],
                "country" => "MX",
                "address1" => $direccion_almacen['calle'] . " " . $direccion_almacen['numero_exterior'] . " " . $direccion_almacen['numero_interior'],
                "company" => "MTM",
                "address2" => $direccion_almacen['colonia'],
                "phone" => $direccion_almacen['numero_telefono'],
                "email" => "Pak2go@email.com",
                "rfc" => "ABCD900627RCM"
            ],
            "parcels" => [
                [
                    "weight" => ($peso < 1) ? 1 : $peso,
                    "distance_unit" => "CM",
                    "mass_unit" => "KG",
                    "height" => intval($caja_envio['alto']),
                    "width" => intval($caja_envio['ancho']),
                    "length" => intval($caja_envio['largo']),
                    "contents" => $cotenido_paquete,
                    //Aquí va a ir el codigo del proucto más voluminoso
                    "product_code_sat" => "50171832",
                    "type_of" => "box"
                ]
            ],
            "address_to" => [
                "deliver_type" => "address",
                "province" => $direccion_envio['estado'],
                "city" => $direccion_envio['delegacion'],
                "name" => $direccion_envio['nombre_receptor'],
                "zip" => $direccion_envio['cp'],
                "country" => "MX",
                "address1" => $direccion_envio['calle'] . ' ' . $direccion_envio['numero_exterior'] . ' ' . $direccion_envio['numero_interior'],
                "company" => $direccion_envio['nombre_receptor'],
                "address2" => $direccion_envio['colonia'],
                "phone" => $direccion_envio['numero_celular'],
                "email" => $correo_usuario,
                "rfc" => (is_null($direccion_facturacion)) ? 'XAXX010101000' : $direccion_facturacion['rfc'],
                "reference" => $direccion_envio['referencia']
            ]
        ];

        $response = Pak2Go::createShipment($data);
        
        if (!$response) {
            $response['response'] = 'error';
            $response['data'] = 'No se pudo crear el envío';
            echo json_encode($response);
            return;
        }

        $ratesObjects = [];

        foreach ($response['included'] as $object) {
            if ($object['type'] === 'rates') {
                $ratesObjects[] = $object;
            }
        }

        $is_express = explode(' ', $nombre_paquetria_seleccionada);

        $paqueteria_seleccionada = [];

        // if ($nombre_paquetria_seleccionada == 'PAQUETEXPRESS') {
        //     $paqueteria_seleccionada = array_values(array_filter($ratesObjects, function ($rateObject) use ($nombre_paquetria_seleccionada) {
        //         return $rateObject['attributes']['provider'] === $nombre_paquetria_seleccionada;
        //     }));
        // } else if (count($is_express) > 1) {
        //     $nombre_paquetria_seleccionada = $is_express[0];

        //     $paqueteria_seleccionada = array_values(array_filter($ratesObjects, function ($rateObject) use ($nombre_paquetria_seleccionada) {
        //         $service_level_name = $rateObject['attributes']['service_level_name'];
        //         $provider = $rateObject['attributes']['provider'];

        //         return $provider === $nombre_paquetria_seleccionada && (strpos($service_level_name, 'Express') !== false);
        //     }));
        // } else {
        //     $paqueteria_seleccionada = array_values(array_filter($ratesObjects, function ($rateObject) use ($nombre_paquetria_seleccionada) {
        //         $service_level_name = $rateObject['attributes']['service_level_name'];
        //         $provider = $rateObject['attributes']['provider'];

        //         return $provider === $nombre_paquetria_seleccionada && (strpos($service_level_name, 'Terrestre') !== false);
        //     }));
        // }

        $paqueteria_seleccionada = array_values(array_filter($ratesObjects, function ($rateObject) use ($nombre_paquetria_seleccionada, $is_express) {
            $provider = $rateObject['attributes']['provider'];
            $service_level_name = $rateObject['attributes']['service_level_name'];
        
            if ($nombre_paquetria_seleccionada == 'PAQUETEXPRESS') {
                return $provider === $nombre_paquetria_seleccionada;
            } else if (count($is_express) > 1 && strpos($service_level_name, 'Express') !== false) {
                return $provider === $is_express[0];
            } else {
                return $provider === $nombre_paquetria_seleccionada && strpos($service_level_name, 'Terrestre') !== false;
            }
        }));

        // $paqueteria_seleccionada now contains the object with the specified provider value
        $rate_id = array(
            "rate_id" => $paqueteria_seleccionada[0]['id'],
            "label_format" => "pdf",
        );

        $guide = Pak2Go::generateGuide($rate_id);

        $detalles_envio = array(
            'provider' => $paqueteria_seleccionada[0]['attributes']['provider'],
            'out_of_area' => $paqueteria_seleccionada[0]['attributes']['out_of_area'],
            'out_of_area_pricing' => $paqueteria_seleccionada[0]['attributes']['out_of_area_pricing'],
            'total_pricing' => $paqueteria_seleccionada[0]['attributes']['total_pricing'],
            'tracking_number' => $guide['data']['attributes']['tracking_number'],
            'tracking_url_provider' => $guide['data']['attributes']['tracking_url_provider']
        );

        return $detalles_envio;
    }
}
