<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/orden.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_orden']) ||
    !isset($_POST['id_estado_orden'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_orden = $_POST['id_orden'];
$id_estado_orden = $_POST['id_estado_orden'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('orden', $id_orden));

$orden = Orden::mdlUpdateEstadoOrden($id_orden, $id_estado_orden);

if (!$orden) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizo el estado de la orden';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'orden', $id_orden, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $orden;

echo json_encode($response);