<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/orden.php';
require '../../modelo/producto_orden.php';
require '../../modelo/precio.php';
require '../usuario/decodeUsuario.php';
$response = array();

if (
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$productos_orden = Orden::mdlGetOrdenesByIdUsuario($id_usuario);

if (!$productos_orden) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró la orden';
    echo json_encode($response);
    return;
}

$ordenes = array();

foreach ($productos_orden as $key => $producto) {
    $total = 0;

    $ordenes[$key]['id_orden'] = $producto['id_orden'];
    $ordenes[$key]['identificador'] = $producto['numero_orden'];
    $ordenes[$key]['fecha'] = $producto['fecha_alta'];
    $ordenes[$key]['id_estado_orden'] = $producto['id_estado_orden'];
    $ordenes[$key]['estado_orden'] = $producto['estado_orden'];

    $producto_orden = ProductoOrden::mdlGetProductoOrdenByIdOrden($producto['id_orden']);

    foreach ($producto_orden as $producto_orden => $info_producto) {
        $ordenes[$key]['productos'][$producto_orden]['nombre'] = $info_producto['nombre'];

        $imagenes = json_decode($info_producto['imagenes']);
        $url_servidor = Environment::getUrlServidor();
        $ordenes[$key]['productos'][$producto_orden]['url_imagen'] = $url_servidor . $imagenes[0]->url;

        $ordenes[$key]['productos'][$producto_orden]['cantidad'] = $info_producto['cantidad'];
        $ordenes[$key]['productos'][$producto_orden]['precio'] = $info_producto['precio'];

        $total += $info_producto['cantidad'] * $info_producto['precio'];
    }

    $precio_envio = Precio::mdlGetPrecioEnvioByOrden($producto['id_orden']);
    $total += $precio_envio['precio'];
    $ordenes[$key]['total_pagado'] = $total;
}

$response['response'] = 'success';
$response['data'] = $ordenes;
echo json_encode($response);
