<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../../modelo/orden.php';
require '../../modelo/direccion_facturacion.php';
require '../../modelo/direccion_envio.php';
require '../../modelo/environment.php';
require '../usuario/decodeUsuario.php';

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_orden'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$url_servidor = Environment::getUrlServidor();

// 1. Obtenemos los datos generales de la orden
$id_orden = $_POST['id_orden'];
$data = Orden::mdlGetOrdenById($id_orden);

if (!$data) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró la orden.';
    echo json_encode($response);
    return;
}

// 1.1 Agregamos el nombre completo del usuario que viene en $data
$data['nombre_cliente'] = $data['nombre_usuario'] . ' ' . $data['apellido_paterno_usuario'] . ' ' . $data['apellido_materno_usuario'];
$fecha = date($data['fecha_alta']);
$fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
$data['fecha_alta'] = $fechaFormat;

// 2. Obtenemos los productos de la orden
$productos = Orden::mdlGetProductosOrden($id_orden);

// 2.1 Obtenemos el número de guia que le corresponde a cada producto de la orden
$total_precio_productos = 0;
foreach ($productos as $key => $producto) {
    $producto_data = Orden::mdlGetGuiaProducto($producto['id_producto_orden']);
    $productos[$key]['numero_rastreo'] = $producto_data['numero_rastreo'];
    $productos[$key]['nombre_paqueteria'] = $producto_data['nombre_paqueteria'];

    $imagenes = json_decode($producto['imagenes']);
    $productos[$key]['url_imagen'] = $url_servidor . $imagenes[0]->url;

    // Sumamos su precio para obtener el total de los productos
    $total_precio_productos += ($producto['precio_producto'] * $producto['cantidad']);
}

$data['productos'] = $productos;
$data['total_precio_productos'] = $total_precio_productos;

// 3. Obtenemos los números de rastreo de la orden
$guias = Orden::mdlGetGuiasOrden($id_orden);

// 3.1 Por cada número de guia, hay que saber sus productos
$total_precio_guias = 0;
foreach ($guias as $key => $guia) {
    $productos_guia = Orden::mdlGetProductosGuia($guia['id_guia_envio_orden']);

    // Agregamos la url_imagen a cada producto
    foreach ($productos_guia as $key_producto => $producto) {
        $imagenes = json_decode($producto['imagenes']);
        $productos_guia[$key_producto]['url_imagen'] = $url_servidor . $imagenes[0]->url;
    }

    $guias[$key]['productos'] = $productos_guia;

    // Agregamos el nombre del almacen a cada guia
    $nombre_almacen = $productos_guia[0]['nombre_almacen'];
    $guias[$key]['nombre_almacen'] = $nombre_almacen;

    // Sumamos su precio para obtener el total de las guias
    $total_precio_guias += $guia['precio'];
}

$data['guias'] = $guias;
$data['total_precio_guias'] = $total_precio_guias;

// 4. Obtenemos los datos de la dirección de envío
$direccion = DireccionEnvio::mdlGetDireccionEnvioByIdOrden($id_orden);
$data['direccion_envio'] = $direccion;

// 5. Obtenemos los datos de la dirección de facturación
if (!is_null($data['id_direccion_facturacion'])) {
    $direccion_facturacion = DireccionFacturacion::mdlGetDireccionFacturacionByIdOrden($id_orden);
    $data['direccion_facturacion'] = $direccion_facturacion;
}

$response['response'] = 'success';
$response['data'] = $data;
echo json_encode($response);
